/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dTrade;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

public class OpenTradesCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("trades") && !scriptEntry.hasObject("entity") && arg.matchesArgumentList(dTrade.class)) {
                scriptEntry.addObject("trades", arg.asType(dList.class).filter(dTrade.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("trades") && !scriptEntry.hasObject("entity") && arg.matchesArgumentType(dEntity.class)) {
                scriptEntry.addObject("entity", arg.asType(dEntity.class));
                continue;
            }
            if (arg.matchesPrefix("title")) {
                scriptEntry.addObject("title", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("players") && arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("players", arg.asType(dList.class).filter(dPlayer.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("trades") && !scriptEntry.hasObject("entity")) {
            throw new InvalidArgumentsException("Must specify a villager entity or a list of trades for the player(s) to trade with!");
        }
        scriptEntry.defaultObject("title", new Element("")).defaultObject("players", Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer()));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        String title = scriptEntry.getElement("title").asString();
        dEntity entity = (dEntity)scriptEntry.getdObject("entity");
        List trades = (List)scriptEntry.getObject("trades");
        List players = (List)scriptEntry.getObject("players");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), (entity != null ? aH.debugObj("entity", entity) : "") + (trades != null ? aH.debugList("trades", trades) : "") + (title.isEmpty() ? aH.debugObj("title", title) : "") + aH.debugList("players", players));
        }
        if (entity != null) {
            if (players.size() > 1) {
                dB.echoError("No more than one player can access the same entity!");
                return;
            }
            if (entity.getBukkitEntity() instanceof Merchant) {
                dPlayer player = (dPlayer)players.get(0);
                if (player.isValid() && player.isOnline()) {
                    player.getPlayerEntity().openMerchant((Merchant)entity.getBukkitEntity(), true);
                } else {
                    dB.echoError("Tried to make a nonexistent or offline player trade with a villager entity!");
                }
                return;
            }
            dB.echoError("The specified entity isn't a merchant!");
            return;
        }
        ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
        for (dTrade trade : trades) {
            recipes.add(trade.getRecipe());
        }
        for (dPlayer player : players) {
            if (player.isValid() && player.isOnline()) {
                Merchant merchant = Bukkit.createMerchant((String)title);
                merchant.setRecipes(recipes);
                player.getPlayerEntity().openMerchant(merchant, true);
                continue;
            }
            dB.echoError("Tried to make a nonexistent or offline player view a virtual trading inventory!");
        }
    }
}

