/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.interfaces.AdvancementHelper;
import net.aufdemrand.denizen.nms.util.Advancement;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ToastCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("targets") && arg.matchesPrefix("target", "targets", "t") && arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("targets", arg.asType(dList.class).filter(dPlayer.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("icon") && arg.matchesPrefix("icon", "i") && arg.matchesArgumentType(dItem.class)) {
                scriptEntry.addObject("icon", arg.asType(dItem.class));
                continue;
            }
            if (!scriptEntry.hasObject("frame") && arg.matchesPrefix("frame", "f") && arg.matchesEnum(Advancement.Frame.values())) {
                scriptEntry.addObject("frame", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("background") && arg.matchesOnePrefix("background")) {
                scriptEntry.addObject("background", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("text")) {
                scriptEntry.addObject("text", new Element(arg.raw_value));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("text")) {
            throw new InvalidArgumentsException("Must specify a message!");
        }
        if (!scriptEntry.hasObject("targets")) {
            BukkitScriptEntryData data = (BukkitScriptEntryData)scriptEntry.entryData;
            if (!data.hasPlayer()) {
                throw new InvalidArgumentsException("Must specify valid player targets!");
            }
            scriptEntry.addObject("targets", Collections.singletonList(data.getPlayer()));
        }
        scriptEntry.defaultObject("icon", new dItem(Material.AIR));
        scriptEntry.defaultObject("frame", new Element("TASK"));
        scriptEntry.defaultObject("background", new Element("textures/gui/advancements/backgrounds/adventure.png"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        int index;
        Element text = scriptEntry.getElement("text");
        Element frame = scriptEntry.getElement("frame");
        Element background = scriptEntry.getElement("background");
        dItem icon = (dItem)scriptEntry.getdObject("icon");
        List targets = (List)scriptEntry.getObject("targets");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.name, text.debug() + frame.debug() + icon.debug() + background.debug() + aH.debugList("targets", targets));
        }
        NamespacedKey backgroundKey = (index = background.asString().indexOf(58)) == -1 ? NamespacedKey.minecraft((String)background.asString()) : new NamespacedKey(background.asString().substring(0, index), background.asString().substring(index + 1));
        Advancement advancement = new Advancement(true, new NamespacedKey((Plugin)DenizenAPI.getCurrentInstance(), UUID.randomUUID().toString()), null, icon.getItemStack(), text.asString(), "", backgroundKey, Advancement.Frame.valueOf(frame.asString().toUpperCase()), true, false, true, 0.0f, 0.0f);
        AdvancementHelper advancementHelper = NMSHandler.getInstance().getAdvancementHelper();
        for (dPlayer target : targets) {
            Player player = target.getPlayerEntity();
            if (player == null) continue;
            advancementHelper.grant(advancement, player);
            advancementHelper.revoke(advancement, player);
        }
    }
}

