/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Location;

public class StrikeCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (arg.matches("no_damage") || arg.matches("nodamage")) {
                scriptEntry.addObject("damage", new Element(false));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
        scriptEntry.defaultObject("damage", new Element(true));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        dLocation location = (dLocation)scriptEntry.getObject("location");
        Boolean damage = scriptEntry.getElement("damage").asBoolean();
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), location.debug() + aH.debugObj("Damageable", String.valueOf(damage)));
        }
        if (damage.booleanValue()) {
            location.getWorld().strikeLightning((Location)location);
        } else {
            location.getWorld().strikeLightningEffect((Location)location);
        }
    }
}

