/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.nms.abstracts.ModernBlockData;
import net.aufdemrand.denizen.nms.interfaces.BlockData;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.MaterialCompat;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SwitchCommand
extends AbstractCommand {
    private Map<Location, Integer> taskMap = new ConcurrentHashMap<Location, Integer>(8, 0.9f, 1);

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("locations") && arg.matchesArgumentList(dLocation.class)) {
                scriptEntry.addObject("locations", arg.asType(dList.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("state") && arg.matchesEnum(SwitchState.values())) {
                scriptEntry.addObject("switchstate", new Element(arg.getValue().toUpperCase()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("locations")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        scriptEntry.defaultObject("duration", new Duration(0));
        scriptEntry.defaultObject("switchstate", new Element("TOGGLE"));
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        Player player;
        dList interactLocations = (dList)scriptEntry.getdObject("locations");
        long duration = ((Duration)scriptEntry.getObject("duration")).getTicks();
        SwitchState switchState = SwitchState.valueOf(scriptEntry.getElement("switchstate").asString());
        Player player2 = player = ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity() : null;
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), interactLocations.debug() + aH.debugObj("duration", duration + "t") + aH.debugObj("switchstate", switchState.name()));
        }
        for (final dLocation interactLocation : interactLocations.filter(dLocation.class, scriptEntry)) {
            this.switchBlock(scriptEntry, interactLocation, switchState, player);
            if (duration <= 0L) continue;
            if (this.taskMap.containsKey(interactLocation)) {
                try {
                    Bukkit.getScheduler().cancelTask(this.taskMap.get(interactLocation).intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dB.log("Setting delayed task 'SWITCH' for " + interactLocation.identify());
            this.taskMap.put(interactLocation, Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                @Override
                public void run() {
                    SwitchCommand.this.switchBlock(scriptEntry, interactLocation, SwitchState.TOGGLE, player);
                }
            }, duration));
        }
    }

    public static boolean switchState(Block b) {
        ModernBlockData mbd;
        Boolean switchState;
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2) && (switchState = (mbd = new ModernBlockData(b)).getSwitchState()) != null) {
            return switchState;
        }
        Material type = b.getType();
        if (type == MaterialCompat.IRON_DOOR || type == MaterialCompat.OAK_DOOR || type == Material.DARK_OAK_DOOR || type == Material.BIRCH_DOOR || type == Material.ACACIA_DOOR || type == Material.JUNGLE_DOOR || type == Material.SPRUCE_DOOR) {
            Location location = b.getLocation();
            byte data = b.getData();
            if (data >= 8) {
                location = b.getLocation().clone().add(0.0, -1.0, 0.0);
            }
            return (location.getBlock().getData() & 4) > 0;
        }
        if (type == MaterialCompat.OAK_TRAPDOOR || type == Material.IRON_TRAPDOOR || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2) && (type == Material.DARK_OAK_TRAPDOOR || type == Material.BIRCH_TRAPDOOR || type == Material.ACACIA_TRAPDOOR || type == Material.JUNGLE_TRAPDOOR || type == Material.SPRUCE_TRAPDOOR)) {
            return (b.getData() & 4) > 0;
        }
        return (b.getData() & 8) > 0;
    }

    public void switchBlock(ScriptEntry scriptEntry, Location interactLocation, SwitchState switchState, Player player) {
        boolean currentState = SwitchCommand.switchState(interactLocation.getBlock());
        if (switchState.equals((Object)SwitchState.ON) && !currentState || switchState.equals((Object)SwitchState.OFF) && currentState || switchState.equals((Object)SwitchState.TOGGLE)) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
                ModernBlockData mbd = new ModernBlockData(interactLocation.getBlock());
                mbd.setSwitchState(interactLocation.getBlock(), !currentState);
            } else {
                try {
                    if (interactLocation.getBlock().getType() == MaterialCompat.IRON_DOOR) {
                        Location block = interactLocation.clone().add(0.0, -1.0, 0.0).getBlock().getType() == MaterialCompat.IRON_DOOR ? interactLocation.clone().add(0.0, -1.0, 0.0) : interactLocation;
                        BlockData blockData = NMSHandler.getInstance().getBlockHelper().getBlockData(MaterialCompat.IRON_DOOR, (byte)(block.getBlock().getData() ^ 4));
                        blockData.setBlock(block.getBlock(), false);
                    } else {
                        if (player == null && Bukkit.getOnlinePlayers().size() > 0) {
                            if (Bukkit.getOnlinePlayers().size() > 0) {
                                player = (Player)Bukkit.getOnlinePlayers().toArray()[0];
                            } else if (Depends.citizens != null) {
                                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                                    if (!npc.isSpawned() || !(npc.getEntity() instanceof Player)) continue;
                                    player = (Player)npc.getEntity();
                                    break;
                                }
                            }
                        }
                        NMSHandler.getInstance().getEntityHelper().forceInteraction(player, interactLocation);
                    }
                }
                catch (NullPointerException e) {
                    dB.echoError("Cannot switch " + interactLocation.getBlock().getType().toString() + "!");
                    return;
                }
            }
            dB.echoDebug((Debuggable)scriptEntry, "Switched " + interactLocation.getBlock().getType().toString() + "! Current state now: " + (SwitchCommand.switchState(interactLocation.getBlock()) ? "ON" : "OFF"));
        }
    }

    private static enum SwitchState {
        ON,
        OFF,
        TOGGLE;

    }
}

