/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.commands.core.CooldownCommand;
import net.aufdemrand.denizen.scripts.containers.core.AssignmentScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.ChatColor;

public class InteractScriptHelper {
    /*
     * WARNING - void declaration
     */
    public static InteractScriptContainer getInteractScript(dNPC npc, dPlayer player, Class<? extends AbstractTrigger> trigger) {
        if (npc == null || player == null || trigger == null) {
            return null;
        }
        AssignmentScriptContainer assignmentScript = npc.getAssignmentTrait().getAssignment();
        if (assignmentScript == null) {
            return null;
        }
        List<Object> assignedScripts = new ArrayList();
        if (assignmentScript.contains("INTERACT SCRIPTS")) {
            assignedScripts = assignmentScript.getStringList("INTERACT SCRIPTS");
        }
        if (assignedScripts.isEmpty()) {
            return null;
        }
        if (dB.shouldDebug(assignmentScript)) {
            dB.log(dB.DebugElement.Header, "Getting interact script: n@" + npc.getName() + "/p@" + player.getName());
        }
        ArrayList<PriorityPair> interactableScripts = new ArrayList<PriorityPair>();
        for (String string : assignedScripts) {
            void var7_8;
            int priority;
            String name;
            block28: {
                String string2 = string.toUpperCase();
                name = null;
                if (Character.isDigit(string2.charAt(0))) {
                    try {
                        priority = Integer.parseInt(string2.split(" ", 2)[0]);
                        name = string2.split(" ", 2)[1].replace("^", "");
                        break block28;
                    }
                    catch (Exception e) {
                        dB.echoError("Invalid Interact assignment for '" + string2 + "'. Is the script name missing?");
                        continue;
                    }
                }
                name = string2;
                String string3 = "0 " + string2;
                priority = 0;
            }
            try {
                InteractScriptContainer interactScript2 = (InteractScriptContainer)ScriptRegistry.getScriptContainer(name);
                if (interactScript2 != null) {
                    if (CooldownCommand.checkCooldown(player, interactScript2.getName())) {
                        interactableScripts.add(new PriorityPair(priority, var7_8.split(" ", 2)[1]));
                    } else if (dB.shouldDebug(interactScript2)) {
                        dB.log(ChatColor.GOLD + " ...but, isn't cooled down, yet! Skipping.");
                    }
                } else {
                    dB.echoError("'" + (String)var7_8 + "' is not a valid Interact Script. Is there a duplicate script by this name?");
                }
            }
            catch (Exception e) {
                dB.echoError(ChatColor.RED + "'" + (String)var7_8 + "' has a bad requirement, skipping.");
                dB.echoError(e);
            }
            if (!dB.shouldDebug(assignmentScript)) continue;
            dB.log(dB.DebugElement.Spacer, null);
        }
        if (interactableScripts.size() == 1) {
            String script = ((PriorityPair)interactableScripts.get(0)).getName();
            InteractScriptContainer interactScriptContainer = (InteractScriptContainer)ScriptRegistry.getScriptContainer(script.replace("^", ""));
            if (dB.shouldDebug(interactScriptContainer)) {
                dB.echoApproval("Highest scoring script is " + script + ".");
            }
            if (dB.shouldDebug(assignmentScript)) {
                dB.log("Current step for this script is: " + InteractScriptHelper.getCurrentStep(player, script));
            }
            if (dB.shouldDebug(interactScriptContainer)) {
                dB.log(dB.DebugElement.Footer, "");
            }
            return interactScriptContainer;
        }
        if (interactableScripts.isEmpty()) {
            if (dB.shouldDebug(assignmentScript)) {
                dB.log(ChatColor.YELLOW + "+> " + ChatColor.WHITE + "No scripts meet requirements!");
                dB.log(dB.DebugElement.Footer, "");
            }
            return null;
        }
        Collections.sort(interactableScripts);
        for (int a = interactableScripts.size() - 1; a >= 0; --a) {
            InteractScriptContainer interactScriptContainer = (InteractScriptContainer)ScriptRegistry.getScriptContainer(((PriorityPair)interactableScripts.get(a)).name.replace("^", ""));
            if (dB.shouldDebug(interactScriptContainer)) {
                dB.log("Checking script '" + ((PriorityPair)interactableScripts.get(a)).getName() + "'.");
            }
            if (((PriorityPair)interactableScripts.get(a)).getName().startsWith("^")) {
                if (interactScriptContainer.containsTriggerInStep(InteractScriptHelper.getCurrentStep(player, interactScriptContainer.getName()), trigger)) {
                    if (dB.shouldDebug(interactScriptContainer)) {
                        dB.log("...found trigger!");
                        dB.echoApproval("Highest scoring script is " + interactScriptContainer.getName() + ".");
                        dB.log("Current step for this script is: " + InteractScriptHelper.getCurrentStep(player, interactScriptContainer.getName()));
                        dB.log(dB.DebugElement.Footer, "");
                    }
                    return interactScriptContainer;
                }
                if (!dB.shouldDebug(interactScriptContainer)) continue;
                dB.log("...no trigger on this overlay assignment. Skipping.");
                continue;
            }
            if (dB.shouldDebug(interactScriptContainer)) {
                dB.log("...script is good!");
                dB.echoApproval("Highest scoring script is " + interactScriptContainer.getName() + ".");
                dB.log("Current step for this script is: " + InteractScriptHelper.getCurrentStep(player, interactScriptContainer.getName()));
                dB.log(dB.DebugElement.Footer, "");
            }
            return interactScriptContainer;
        }
        return null;
    }

    public static String getCurrentStep(dPlayer player, String scriptName) {
        if (scriptName == null) {
            return null;
        }
        if (DenizenAPI._saves().contains("Players." + player.getSaveName() + ".Scripts." + scriptName.toUpperCase() + ".Current Step")) {
            return DenizenAPI._saves().getString("Players." + player.getSaveName() + ".Scripts." + scriptName.toUpperCase() + ".Current Step").toUpperCase();
        }
        return ScriptRegistry.getScriptContainerAs(scriptName, InteractScriptContainer.class).getDefaultStepName().toUpperCase();
    }

    private static class PriorityPair
    implements Comparable<PriorityPair> {
        int priority;
        private String name;

        public PriorityPair(int priority, String scriptName) {
            this.priority = priority;
            this.name = scriptName.toUpperCase();
        }

        @Override
        public int compareTo(PriorityPair pair) {
            return this.priority < pair.priority ? -1 : (this.priority > pair.priority ? 1 : 0);
        }

        public String getName() {
            return this.name;
        }
    }
}

