/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands.core;

import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.BracedCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.utilities.scheduling.OneTimeSchedulable;

public class SyncCommand
extends BracedCommand
implements Holdable {
    @Override
    public void onEnable() {
        this.setBraced();
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        scriptEntry.addObject("braces", SyncCommand.getBracedCommands(scriptEntry));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ScriptQueue residingQueue = scriptEntry.getResidingQueue();
        final InstantQueue queue = new InstantQueue("SYNC_COMMAND");
        queue.addEntries(((BracedCommand.BracedData)((List)scriptEntry.getObject((String)"braces")).get((int)0)).value);
        queue.getAllDefinitions().putAll(residingQueue.getAllDefinitions());
        if (residingQueue.cachedContext != null) {
            queue.cachedContext = new HashMap();
            queue.cachedContext.putAll(residingQueue.cachedContext);
        }
        if (scriptEntry.shouldWaitFor()) {
            final ScriptEntry se = scriptEntry;
            queue.callBack(new Runnable(){

                @Override
                public void run() {
                    se.setFinished(true);
                }
            });
        }
        if (residingQueue.run_async) {
            DenizenCore.schedule(new OneTimeSchedulable(new Runnable(){

                @Override
                public void run() {
                    queue.start();
                }
            }, 0.0f));
        } else {
            queue.start();
        }
    }
}

