/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.tags.core;

import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.DefinitionProvider;
import net.aufdemrand.denizencore.utilities.debugging.SlowWarning;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class DefinitionTags {
    public SlowWarning defShorthand = new SlowWarning("Short-named tags are hard to read. Please use 'def' instead of 'd' as a root tag.");

    public DefinitionTags() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                DefinitionTags.this.definitionTag(event);
            }
        }, "definition", "def", "d", "");
    }

    public void definitionTag(ReplaceableTagEvent event) {
        if (!event.matches("definition", "def", "d", "")) {
            return;
        }
        if (event.matches("d")) {
            this.defShorthand.warn(event.getScriptEntry());
        }
        if (!event.hasNameContext()) {
            dB.echoError("Invalid definition tag, no context specified!");
            return;
        }
        String defName = event.getNameContext();
        DefinitionProvider definitionProvider = event.getContext().definitionProvider;
        if (definitionProvider == null) {
            dB.echoError("No definitions are provided at this moment!");
            return;
        }
        dObject def = definitionProvider.getDefinitionObject(defName);
        Attribute atttribute = event.getAttributes().fulfill(1);
        if (atttribute.startsWith("exists")) {
            if (def == null) {
                event.setReplacedObject(CoreUtilities.autoAttrib(new Element(false), atttribute.fulfill(1)));
            } else {
                event.setReplacedObject(CoreUtilities.autoAttrib(new Element(true), atttribute.fulfill(1)));
            }
            return;
        }
        if (def == null) {
            if (!event.hasAlternative()) {
                dB.echoError("Invalid definition name '" + defName + "'.");
            }
            return;
        }
        event.setReplacedObject(CoreUtilities.autoAttribTyped(def, atttribute));
    }
}

