/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ReflectionHelper {
    private static final Map<Class, Map<String, Field>> cachedFields = new HashMap<Class, Map<String, Field>>();
    private static final Map<Class, Map<String, MethodHandle>> cachedFieldSetters = new HashMap<Class, Map<String, MethodHandle>>();
    private static MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static Field MODIFIERS_FIELD = ReflectionHelper.getFields(Field.class).get("modifiers");
    private static Object UNSAFE;
    private static MethodHandle UNSAFE_FIELD_OFFSET;
    private static MethodHandle UNSAFE_PUT_OBJECT;
    private static MethodHandle UNSAFE_STATIC_FIELD_OFFSET;

    public static <T> T getFieldValue(Class clazz, String fieldName, Object object) {
        Map<String, Field> cache = ReflectionHelper.getFields(clazz);
        try {
            Field field = cache.get(fieldName);
            if (field == null) {
                return null;
            }
            cache.put(fieldName, field);
            return (T)field.get(object);
        }
        catch (Exception ex) {
            dB.echoError((Throwable)ex);
            return null;
        }
    }

    public static void setFieldValue(Class clazz, String fieldName, Object object, Object value) {
    }

    public static Map<String, Field> getFields(Class clazz) {
        Map<String, Field> fields = cachedFields.get(clazz);
        if (fields != null) {
            return fields;
        }
        fields = new HashMap<String, Field>();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            fields.put(field.getName(), field);
        }
        cachedFields.put(clazz, fields);
        return fields;
    }

    public static Method getMethod(Class<?> clazz, String method, Class<?> ... params) {
        Method f = null;
        try {
            f = clazz.getDeclaredMethod(method, params);
            f.setAccessible(true);
        }
        catch (Exception ex) {
            dB.echoError((Throwable)ex);
        }
        return f;
    }

    public static MethodHandle getMethodHandle(Class<?> clazz, String method, Class<?> ... params) {
        try {
            return LOOKUP.unreflect(ReflectionHelper.getMethod(clazz, method, params));
        }
        catch (Exception ex) {
            dB.echoError((Throwable)ex);
            return null;
        }
    }

    public static MethodHandle getFinalSetter(Class<?> clazz, String field) {
        MethodHandle result;
        Map<String, MethodHandle> map = cachedFieldSetters.get(clazz);
        if (map == null) {
            map = new HashMap<String, MethodHandle>();
            cachedFieldSetters.put(clazz, map);
        }
        if ((result = map.get(field)) != null) {
            return result;
        }
        Field f = ReflectionHelper.getFields(clazz).get(field);
        if (f == null) {
            return null;
        }
        int mod = f.getModifiers();
        try {
            if (MODIFIERS_FIELD == null) {
                ReflectionHelper.validateUnsafe();
                boolean isStatic = Modifier.isStatic(mod);
                long offset = (Long)(isStatic ? UNSAFE_STATIC_FIELD_OFFSET.invoke(f) : UNSAFE_FIELD_OFFSET.invoke(f));
                result = isStatic ? MethodHandles.insertArguments(UNSAFE_PUT_OBJECT, 0, clazz, offset) : MethodHandles.insertArguments(UNSAFE_PUT_OBJECT, 1, offset);
            } else {
                if (Modifier.isFinal(mod)) {
                    MODIFIERS_FIELD.setInt(f, mod & 0xFFFFFFEF);
                }
                result = LOOKUP.unreflectSetter(f);
            }
        }
        catch (Throwable ex) {
            dB.echoError((Throwable)ex);
            return null;
        }
        if (result == null) {
            return null;
        }
        cachedFieldSetters.get(clazz).put(field, result);
        return result;
    }

    private static void validateUnsafe() {
        if (UNSAFE == null) {
            try {
                UNSAFE = ReflectionHelper.getFields(Class.forName("sun.misc.Unsafe")).get("theUnsafe");
            }
            catch (Exception ex) {
                dB.echoError((Throwable)ex);
            }
            UNSAFE_STATIC_FIELD_OFFSET = ReflectionHelper.getMethodHandle(UNSAFE.getClass(), "staticFieldOffset", Field.class).bindTo(UNSAFE);
            UNSAFE_FIELD_OFFSET = ReflectionHelper.getMethodHandle(UNSAFE.getClass(), "objectFieldOffset", Field.class).bindTo(UNSAFE);
            UNSAFE_PUT_OBJECT = ReflectionHelper.getMethodHandle(UNSAFE.getClass(), "putObject", Object.class, Long.TYPE, Object.class).bindTo(UNSAFE);
        }
    }
}

