/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreeperPowerEvent;

public class CreeperPoweredScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static CreeperPoweredScriptEvent instance;
    public dEntity lightning;
    public dEntity entity;
    public Element cause;
    public CreeperPowerEvent event;

    public CreeperPoweredScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("creeper powered");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.eventArgLowerAt(2).equals("because") && !path.eventArgLowerAt(3).equals(CoreUtilities.toLowerCase(this.cause.toString()))) {
            return false;
        }
        return this.runInCheck(path, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "CreeperPowered";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("lightning") && this.lightning != null) {
            return this.lightning;
        }
        if (name.equals("cause")) {
            return this.cause;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCreeperPowered(CreeperPowerEvent event) {
        this.lightning = new dEntity((Entity)event.getLightning());
        this.entity = new dEntity((Entity)event.getEntity());
        this.cause = new Element(event.getCause().name());
        this.event = event;
        this.fire((Event)event);
    }
}

