/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EnderDragonChangePhaseEvent;

public class DragonPhaseChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static DragonPhaseChangeScriptEvent instance;
    public dEntity entity;
    public EnderDragonChangePhaseEvent event;

    public DragonPhaseChangeScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).contains("changes phase");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        if (!this.tryEntity(this.entity, target)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        if (!this.runGenericSwitchCheck(path, "from", this.event.getCurrentPhase() == null ? "null" : this.event.getCurrentPhase().name())) {
            return false;
        }
        return this.runGenericSwitchCheck(path, "to", this.event.getNewPhase().name());
    }

    @Override
    public String getName() {
        return "DragonPhaseChanged";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (!DragonPhaseChangeScriptEvent.isDefaultDetermination(determination)) {
            EnderDragon.Phase phase = EnderDragon.Phase.valueOf((String)determination.toUpperCase());
            this.event.setNewPhase(phase);
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("old_phase")) {
            return new Element(this.event.getCurrentPhase() == null ? "null" : this.event.getCurrentPhase().name());
        }
        if (name.equals("new_phase")) {
            return new Element(this.event.getNewPhase().name());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEnderDragonChangePhase(EnderDragonChangePhaseEvent event) {
        this.entity = new dEntity((Entity)event.getEntity());
        this.event = event;
        this.fire((Event)event);
    }
}

