/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;

public class EntityBreaksHangingScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityBreaksHangingScriptEvent instance;
    public Element cause;
    public dEntity breaker;
    public dEntity hanging;
    public dLocation location;
    public HangingBreakByEntityEvent event;

    public EntityBreaksHangingScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("breaks");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String entName = path.eventArgLowerAt(0);
        String hang = path.eventArgLowerAt(2);
        if (!this.tryEntity(this.breaker, entName)) {
            return false;
        }
        if (!hang.equals("hanging") && !this.tryEntity(this.hanging, hang)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return !path.eventArgLowerAt(3).equals("because") || path.eventArgLowerAt(4).equals(CoreUtilities.toLowerCase(this.cause.asString()));
    }

    @Override
    public String getName() {
        return "EntityBreaksHanging";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.breaker.isPlayer() ? this.breaker.getDenizenPlayer() : null, this.breaker.isCitizensNPC() ? this.breaker.getDenizenNPC() : null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("cause")) {
            return this.cause;
        }
        if (name.equals("entity")) {
            return this.breaker;
        }
        if (name.equals("breaker")) {
            return this.breaker;
        }
        if (name.equals("hanging")) {
            return this.hanging;
        }
        if (name.equals("cuboids")) {
            dB.echoError("context.cuboids tag is deprecated in " + this.getName() + " script event");
            dList cuboids = new dList();
            for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
                cuboids.add(cuboid.identifySimple());
            }
            return cuboids;
        }
        if (name.equals("location")) {
            return this.location;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onHangingBreaks(HangingBreakByEntityEvent event) {
        this.hanging = new dEntity((Entity)event.getEntity());
        this.cause = new Element(event.getCause().name());
        this.location = new dLocation(this.hanging.getLocation());
        this.breaker = new dEntity(event.getRemover());
        this.event = event;
        this.fire((Event)event);
    }
}

