/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.properties.entity.EntityPotionEffects;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityPotionEffectScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityPotionEffectScriptEvent instance;
    public dEntity entity;
    public EntityPotionEffectEvent event;

    public EntityPotionEffectScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).contains(" potion effects ");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        String change = path.eventArgAt(3);
        if (!change.equals("modified") && !this.runGenericCheck(change, CoreUtilities.toLowerCase(this.event.getAction().name()))) {
            return false;
        }
        if (!this.tryEntity(this.entity, target)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        if (!this.runGenericSwitchCheck(path, "cause", CoreUtilities.toLowerCase(this.event.getCause().name()))) {
            return false;
        }
        return this.runGenericSwitchCheck(path, "effect", CoreUtilities.toLowerCase(this.event.getModifiedType().getName()));
    }

    @Override
    public String getName() {
        return "PotionEffectsModified";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("override:")) {
            this.event.setOverride(lower.substring("override".length()).equals("true"));
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? dEntity.getPlayerFrom(this.event.getEntity()) : null, this.entity.isCitizensNPC() ? dEntity.getNPCFrom(this.event.getEntity()) : null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("cause")) {
            return new Element(this.event.getCause().name());
        }
        if (name.equals("action")) {
            return new Element(this.event.getAction().name());
        }
        if (name.equals("effect_type")) {
            return new Element(this.event.getModifiedType().getName());
        }
        if (name.equals("override")) {
            return new Element(this.event.isOverride());
        }
        if (name.equals("new_effect") && this.event.getNewEffect() != null) {
            return new Element(EntityPotionEffects.stringify(this.event.getNewEffect()));
        }
        if (name.equals("old_effect") && this.event.getOldEffect() != null) {
            return new Element(EntityPotionEffects.stringify(this.event.getOldEffect()));
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityPotionEffect(EntityPotionEffectEvent event) {
        this.entity = new dEntity(event.getEntity());
        this.event = event;
        this.fire((Event)event);
    }
}

