/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.utilities.MaterialCompat;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.inventory.meta.BookMeta;

public class PlayerEditsBookScriptEvent
extends BukkitScriptEvent
implements Listener {
    PlayerEditsBookScriptEvent instance;
    PlayerEditBookEvent event;
    Element signing;
    Element title;
    Element pages;
    dItem book;
    dPlayer player;
    BookMeta bookMeta;

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player edits book") || lower.startsWith("player signs book");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String action = path.eventArgLowerAt(1);
        if (action.equals("edits")) {
            return true;
        }
        return action.equals("signs") && this.signing.asBoolean();
    }

    @Override
    public String getName() {
        return "PlayerEditsBook";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (determination.toUpperCase().equals("NOT_SIGNING")) {
            this.signing = new Element(false);
        } else if (dScript.matches(determination)) {
            dScript script = dScript.valueOf(determination);
            if (script.getContainer() instanceof BookScriptContainer) {
                dItem dBook = ((BookScriptContainer)script.getContainer()).getBookFrom(this.player, null);
                this.bookMeta = (BookMeta)dBook.getItemStack().getItemMeta();
                if (dBook.getMaterial().getMaterial() == MaterialCompat.WRITABLE_BOOK) {
                    this.signing = new Element(false);
                }
            } else {
                dB.echoError("Script '" + determination + "' is valid, but not of type 'book'!");
            }
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("signing")) {
            return this.signing;
        }
        if (name.equals("title")) {
            return this.title;
        }
        if (name.equals("book")) {
            return this.book;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerEditsBook(PlayerEditBookEvent event) {
        this.player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
        this.signing = new Element(event.isSigning());
        this.bookMeta = event.getNewBookMeta();
        this.pages = new Element(this.bookMeta.getPageCount());
        this.title = event.isSigning() ? new Element(this.bookMeta.getTitle()) : null;
        this.book = new dItem(event.getPlayer().getInventory().getItem(event.getSlot()));
        this.event = event;
        this.fire((Event)event);
        event.setNewBookMeta(this.bookMeta);
        event.setSigning(this.signing.asBoolean());
    }
}

