/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;

public class PlayerLoginScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerLoginScriptEvent instance;
    private String message;
    private Boolean kicked;
    public PlayerLoginEvent event;

    public PlayerLoginScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player") && (lower.contains("logs in") || lower.contains("login"));
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        return !CoreUtilities.toLowerCase(s).contains("first") || !dPlayer.isNoted((OfflinePlayer)this.event.getPlayer());
    }

    @Override
    public String getName() {
        return "PlayerLogin";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (CoreUtilities.toLowerCase(determination).startsWith("kicked")) {
            this.message = determination.length() > 7 ? determination.substring(7) : determination;
            this.kicked = true;
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new dPlayer(this.event.getPlayer()), null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("hostname")) {
            return new Element(this.event.getAddress().toString());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.kicked = false;
        this.event = event;
        this.fire((Event)event);
        if (this.kicked.booleanValue()) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.message);
        }
    }
}

