/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingPlaceEvent;

public class PlayerPlacesHangingScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerPlacesHangingScriptEvent instance;
    public dEntity hanging;
    public dLocation location;
    public HangingPlaceEvent event;

    public PlayerPlacesHangingScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player places");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String hangCheck = path.eventArgLowerAt(2);
        if (!this.tryEntity(this.hanging, hangCheck)) {
            return false;
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "PlayerPlacesHanging";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dPlayer.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("hanging")) {
            return this.hanging;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("cuboids")) {
            dB.echoError("context.cuboids tag is deprecated in " + this.getName() + " script event");
            dList cuboids = new dList();
            for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
                cuboids.add(cuboid.identifySimple());
            }
            return cuboids;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void pnPlayerPlacesHanging(HangingPlaceEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        Hanging hangingEntity = event.getEntity();
        dEntity.rememberEntity((Entity)hangingEntity);
        this.hanging = new dEntity((Entity)hangingEntity);
        this.location = new dLocation(event.getBlock().getLocation());
        this.event = event;
        this.fire((Event)event);
        dEntity.forgetEntity((Entity)hangingEntity);
    }
}

