/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;

public class PlayerRightClicksEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    PlayerRightClicksEntityScriptEvent instance;
    PlayerInteractEntityEvent event;
    dEntity entity;
    dItem item;
    dLocation location;

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player right clicks");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        boolean isAt = path.eventArgLowerAt(3).equals("at");
        if (!this.tryEntity(this.entity, path.eventArgLowerAt(isAt ? 4 : 3))) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        if (!this.runWithCheck(path, this.item)) {
            return false;
        }
        return !path.eventArgLowerAt(isAt ? 5 : 4).equals("with") || this.tryItem(this.item, path.eventArgLowerAt(isAt ? 6 : 5));
    }

    @Override
    public String getName() {
        return "PlayerRightClicksEntity";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dPlayer.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), this.entity.isNPC() ? this.entity.getDenizenNPC() : null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("click_position") && this.event instanceof PlayerInteractAtEntityEvent) {
            return new dLocation(((PlayerInteractAtEntityEvent)this.event).getClickedPosition());
        }
        if (name.equals("cuboids")) {
            dB.echoError("context.cuboids tag is deprecated in " + this.getName() + " script event");
            dList cuboids = new dList();
            for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
                cuboids.addObject(cuboid);
            }
            return cuboids;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void playerRightClicksAtEntity(PlayerInteractAtEntityEvent event) {
        this.playerRightClicksEntity((PlayerInteractEntityEvent)event);
    }

    @EventHandler
    public void playerRightClicksEntity(PlayerInteractEntityEvent event) {
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        this.entity = new dEntity(event.getRightClicked());
        this.item = new dItem(event.getPlayer().getItemInHand());
        this.location = new dLocation(event.getRightClicked().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

