/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.StructureGrowEvent;

public class StructureGrowsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static StructureGrowsScriptEvent instance;
    public dWorld world;
    public dLocation location;
    public Element structure;
    public dList blocks;
    public dList new_materials;
    public StructureGrowEvent event;

    public StructureGrowsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        String block = CoreUtilities.getXthArg(0, lower);
        dMaterial mat = dMaterial.valueOf(block);
        return cmd.equals("grows") && (block.equals("structure") || mat != null && mat.isStructure());
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String struct = path.eventArgLowerAt(0);
        if (!(struct.equals("structure") || struct.equals("plant") || struct.equals(CoreUtilities.toLowerCase(this.structure.asString())))) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("from") && !this.event.isFromBonemeal()) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("naturally") && this.event.isFromBonemeal()) {
            return false;
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "StructureGrow";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("world")) {
            return this.world;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("structure")) {
            return this.structure;
        }
        if (name.equals("blocks")) {
            return this.blocks;
        }
        if (name.equals("new_materials")) {
            return this.new_materials;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onStructureGrow(StructureGrowEvent event) {
        this.world = new dWorld(event.getWorld());
        this.location = new dLocation(event.getLocation());
        this.structure = new Element(event.getSpecies().name());
        this.blocks = new dList();
        this.new_materials = new dList();
        for (BlockState block : event.getBlocks()) {
            this.blocks.add(new dLocation(block.getLocation()).identify());
            this.new_materials.add(new dMaterial(block.getType(), block.getRawData()).identify());
        }
        this.event = event;
        this.fire((Event)event);
    }
}

