/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.abstracts;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTag;
import net.aufdemrand.denizen.nms.util.jnbt.DoubleTag;
import net.aufdemrand.denizen.nms.util.jnbt.FloatTag;
import net.aufdemrand.denizen.nms.util.jnbt.ListTag;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;

public abstract class ImprovedOfflinePlayer {
    protected UUID player;
    protected File file;
    protected CompoundTag compound;
    protected boolean exists = false;
    protected boolean autosave = true;
    public static Map<UUID, PlayerInventory> offlineInventories = new HashMap<UUID, PlayerInventory>();
    public static Map<UUID, Inventory> offlineEnderChests = new HashMap<UUID, Inventory>();

    public ImprovedOfflinePlayer(UUID playeruuid) {
        this.exists = this.loadPlayerData(playeruuid);
    }

    public abstract PlayerInventory getInventory();

    public abstract void setInventory(PlayerInventory var1);

    public abstract Inventory getEnderChest();

    public abstract void setEnderChest(Inventory var1);

    public Location getLocation() {
        ListTag position = this.compound.getListTag("Pos");
        ListTag rotation = this.compound.getListTag("Rotation");
        return new Location(Bukkit.getWorld((UUID)new UUID(this.compound.getLong("WorldUUIDMost"), this.compound.getLong("WorldUUIDLeast"))), position.getDouble(0), position.getDouble(1), position.getDouble(2), rotation.getFloat(0), rotation.getFloat(1));
    }

    public void setLocation(Location location) {
        World w = location.getWorld();
        UUID uuid = w.getUID();
        ArrayList<DoubleTag> position = new ArrayList<DoubleTag>();
        position.add(new DoubleTag(location.getX()));
        position.add(new DoubleTag(location.getY()));
        position.add(new DoubleTag(location.getZ()));
        ArrayList<FloatTag> rotation = new ArrayList<FloatTag>();
        rotation.add(new FloatTag(location.getYaw()));
        rotation.add(new FloatTag(location.getPitch()));
        this.compound = this.compound.createBuilder().putLong("WorldUUIDMost", uuid.getMostSignificantBits()).putLong("WorldUUIDLeast", uuid.getLeastSignificantBits()).putInt("Dimension", w.getEnvironment().ordinal()).put("Pos", new ListTag(DoubleTag.class, position)).put("Rotation", new ListTag(FloatTag.class, rotation)).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getHealthFloat() {
        return this.compound.getFloat("Health");
    }

    public void setHealthFloat(float input) {
        this.compound = this.compound.createBuilder().putFloat("Health", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public abstract double getMaxHealth();

    public abstract void setMaxHealth(double var1);

    protected abstract boolean loadPlayerData(UUID var1);

    public abstract void savePlayerData();

    public boolean exists() {
        return this.exists;
    }

    public boolean getAutoSave() {
        return this.autosave;
    }

    public void setAutoSave(boolean autosave) {
        this.autosave = autosave;
    }

    public float getAbsorptionAmount() {
        return this.compound.getFloat("AbsorptionAmount");
    }

    public void setAbsorptionAmount(float input) {
        this.compound = this.compound.createBuilder().putFloat("AbsorptionAmount", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public Location getBedSpawnLocation() {
        return new Location(Bukkit.getWorld((String)this.compound.getString("SpawnWorld")), (double)this.compound.getInt("SpawnX"), (double)this.compound.getInt("SpawnY"), (double)this.compound.getInt("SpawnZ"));
    }

    public boolean isSpawnForced() {
        return this.compound.getBoolean("SpawnForced");
    }

    public void setBedSpawnLocation(Location location, Boolean override) {
        this.compound = this.compound.createBuilder().putInt("SpawnX", (int)location.getX()).putInt("SpawnY", (int)location.getY()).putInt("SpawnZ", (int)location.getZ()).putString("SpawnWorld", location.getWorld().getName()).putBoolean("SpawnForced", override == null ? false : override).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getExhaustion() {
        return this.compound.getFloat("foodExhaustionLevel");
    }

    public void setExhaustion(float input) {
        this.compound = this.compound.createBuilder().putFloat("foodExhaustionLevel", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getExp() {
        return this.compound.getFloat("XpP");
    }

    public void setExp(float input) {
        this.compound = this.compound.createBuilder().putFloat("XpP", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getFallDistance() {
        return this.compound.getFloat("FallDistance");
    }

    public void setFallDistance(float input) {
        this.compound = this.compound.createBuilder().putFloat("FallDistance", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getFireTicks() {
        return this.compound.getShort("Fire");
    }

    public void setFireTicks(int input) {
        this.compound = this.compound.createBuilder().putShort("Fire", (short)input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getFlySpeed() {
        return ((CompoundTag)this.compound.getValue().get("abilities")).getFloat("flySpeed");
    }

    public void setFlySpeed(float speed) {
        CompoundTag compoundTag = (CompoundTag)this.compound.getValue().get("abilities");
        compoundTag = compoundTag.createBuilder().putFloat("flySpeed", speed).build();
        this.compound = this.compound.createBuilder().put("abilities", compoundTag).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getFoodLevel() {
        return this.compound.getInt("foodLevel");
    }

    public void setFoodLevel(int input) {
        this.compound = this.compound.createBuilder().putInt("foodLevel", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getFoodTickTimer() {
        return this.compound.getInt("foodTickTimer");
    }

    public void setFoodTickTimer(int input) {
        this.compound = this.compound.createBuilder().putInt("foodTickTimer", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public GameMode getGameMode() {
        return GameMode.values()[this.compound.getInt("playerGameType")];
    }

    public void setGameMode(GameMode input) {
        this.compound = this.compound.createBuilder().putInt("playerGameType", input.getValue()).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getHealthInt() {
        return this.compound.getShort("Health");
    }

    public void setHealthInt(int input) {
        this.compound = this.compound.createBuilder().putShort("Health", (short)input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public boolean getIsInvulnerable() {
        return this.compound.getBoolean("Invulnerable");
    }

    public void setIsInvulnerable(boolean input) {
        this.compound = this.compound.createBuilder().putBoolean("Invulnerable", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public boolean getIsOnGround() {
        return this.compound.getBoolean("OnGround");
    }

    public void setIsOnGround(boolean input) {
        this.compound = this.compound.createBuilder().putBoolean("OnGround", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public boolean getIsSleeping() {
        return this.compound.getBoolean("Sleeping");
    }

    public void setIsSleeping(boolean input) {
        this.compound = this.compound.createBuilder().putBoolean("Sleeping", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getItemInHand() {
        return this.compound.getInt("SelectedItemSlot");
    }

    public void setItemInHand(int input) {
        this.compound = this.compound.createBuilder().putInt("SelectedItemSlot", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getLevel() {
        return this.compound.getInt("XpLevel");
    }

    public void setLevel(int input) {
        this.compound = this.compound.createBuilder().putInt("XpLevel", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public UUID getUniqueId() {
        return this.player;
    }

    public int getPortalCooldown() {
        return this.compound.getInt("PortalCooldown");
    }

    public void setPortalCooldown(int input) {
        this.compound = this.compound.createBuilder().putInt("PortalCooldown", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getRemainingAir() {
        return this.compound.getShort("Air");
    }

    public void setRemainingAir(int input) {
        this.compound = this.compound.createBuilder().putShort("Air", (short)input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getSaturation() {
        return this.compound.getFloat("foodSaturationLevel");
    }

    public void setSaturation(float input) {
        this.compound = this.compound.createBuilder().putFloat("foodSaturationLevel", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getScore() {
        return this.compound.getFloat("foodSaturationLevel");
    }

    public void setScore(int input) {
        this.compound = this.compound.createBuilder().putInt("Score", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public short getTimeAttack() {
        return this.compound.getShort("AttackTime");
    }

    public void setTimeAttack(short input) {
        this.compound = this.compound.createBuilder().putShort("AttackTime", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public short getTimeDeath() {
        return this.compound.getShort("DeathTime");
    }

    public void setTimeDeath(short input) {
        this.compound = this.compound.createBuilder().putShort("DeathTime", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public short getTimeHurt() {
        return this.compound.getShort("HurtTime");
    }

    public void setTimeHurt(short input) {
        this.compound = this.compound.createBuilder().putShort("HurtTime", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public short getTimeSleep() {
        return this.compound.getShort("SleepTimer");
    }

    public void setTimeSleep(short input) {
        this.compound = this.compound.createBuilder().putShort("SleepTimer", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public int getTotalExperience() {
        return this.compound.getInt("XpTotal");
    }

    public void setTotalExperience(int input) {
        this.compound = this.compound.createBuilder().putInt("XpTotal", input).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public Vector getVelocity() {
        ListTag list = this.compound.getListTag("Motion");
        return new Vector(list.getDouble(0), list.getDouble(1), list.getDouble(2));
    }

    public void setVelocity(Vector vector) {
        ArrayList<DoubleTag> motion = new ArrayList<DoubleTag>();
        motion.add(new DoubleTag(vector.getX()));
        motion.add(new DoubleTag(vector.getY()));
        motion.add(new DoubleTag(vector.getZ()));
        this.compound = this.compound.createBuilder().put("Motion", new ListTag(DoubleTag.class, motion)).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }

    public float getWalkSpeed() {
        return ((CompoundTag)this.compound.getValue().get("abilities")).getFloat("walkSpeed");
    }

    public void setWalkSpeed(float speed) {
        CompoundTag compoundTag = (CompoundTag)this.compound.getValue().get("abilities");
        compoundTag = compoundTag.createBuilder().putFloat("walkSpeed", speed).build();
        this.compound = this.compound.createBuilder().put("abilities", compoundTag).build();
        if (this.autosave) {
            this.savePlayerData();
        }
    }
}

