/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.AssignmentScriptContainer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ActionHandler {
    final Denizen denizen;

    public ActionHandler(Denizen denizen) {
        this.denizen = denizen;
    }

    public String doAction(String actionName, dNPC npc, dPlayer player, AssignmentScriptContainer assignment) {
        return this.doAction(actionName, npc, player, assignment, null);
    }

    public String doAction(String actionName, dNPC npc, dPlayer player, AssignmentScriptContainer assignment, Map<String, dObject> context) {
        if (context == null) {
            context = new HashMap<String, dObject>();
        }
        String determination = "none";
        if (assignment == null) {
            return determination;
        }
        if (!assignment.contains("actions.on " + actionName)) {
            return determination;
        }
        dB.report(assignment, "Action", aH.debugObj("Type", "On " + actionName) + aH.debugObj("NPC", npc.toString()) + assignment.getAsScriptArg().debug() + (player != null ? aH.debugObj("Player", player.getName()) : ""));
        List<ScriptEntry> script = assignment.getEntries(new BukkitScriptEntryData(player, npc), "actions.on " + actionName);
        if (script.isEmpty()) {
            return determination;
        }
        dB.echoDebug(assignment, dB.DebugElement.Header, "Building action 'On " + actionName.toUpperCase() + "' for " + npc.toString());
        ScriptQueue queue = new InstantQueue(assignment.getName()).addEntries(script);
        OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
        oecs.contexts = context;
        oecs.contexts.put("event_header", new Element(actionName));
        queue.setContextSource(oecs);
        queue.start();
        if (queue.determinations != null && queue.determinations.size() > 0) {
            determination = (String)queue.determinations.get(0);
        }
        return determination;
    }
}

