/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import java.util.HashMap;
import java.util.UUID;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.npc.dNPCRegistry;
import net.aufdemrand.denizen.npc.traits.ConstantsTrait;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.AssignmentScriptContainer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.text.StringHolder;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Paginator;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.projectiles.ProjectileSource;

public class AssignmentTrait
extends Trait {
    @Persist
    private String assignment = "";
    private UUID entityId;

    public AssignmentTrait() {
        super("assignment");
    }

    public void load(DataKey key) throws NPCLoadException {
        if (this.hasAssignment()) {
            dB.echoError("Missing assignment '" + this.assignment + "' for NPC '" + this.npc.getName() + "/" + this.npc.getId() + "! Perhaps the script has been removed?");
        }
        ((ConstantsTrait)this.npc.getTrait(ConstantsTrait.class)).rebuildAssignmentConstants();
    }

    public boolean setAssignment(String assignment, dPlayer player) {
        if (ScriptRegistry.containsScript(assignment, AssignmentScriptContainer.class)) {
            this.assignment = assignment.toUpperCase();
            if (!this.npc.hasTrait(ConstantsTrait.class)) {
                this.npc.addTrait(ConstantsTrait.class);
            }
            if (!this.npc.hasTrait(TriggerTrait.class)) {
                this.npc.addTrait(TriggerTrait.class);
            }
            if (Settings.healthTraitEnabledByDefault() && !this.npc.hasTrait(HealthTrait.class)) {
                this.npc.addTrait(HealthTrait.class);
            }
            ((ConstantsTrait)this.npc.getTrait(ConstantsTrait.class)).rebuildAssignmentConstants();
            dNPCRegistry.getDenizen(this.npc).action("assignment", player);
            return true;
        }
        return false;
    }

    public AssignmentScriptContainer getAssignment() {
        if (this.hasAssignment() && ScriptRegistry.containsScript(this.assignment, AssignmentScriptContainer.class)) {
            return (AssignmentScriptContainer)ScriptRegistry.getScriptContainer(this.assignment);
        }
        return null;
    }

    public boolean hasAssignment() {
        if (this.assignment == null || this.assignment.equals("")) {
            return false;
        }
        return ScriptRegistry.containsScript(this.assignment);
    }

    public void removeAssignment(dPlayer player) {
        dNPCRegistry.getDenizen(this.npc).action("remove assignment", player);
        this.assignment = "";
    }

    public void describe(CommandSender sender, int page) throws CommandException {
        AssignmentScriptContainer assignmentScript = (AssignmentScriptContainer)ScriptRegistry.getScriptContainer(this.assignment);
        Paginator paginator = new Paginator().header("Assignment");
        paginator.addLine("<e>Current assignment: " + (this.hasAssignment() ? this.assignment : "None.") + "");
        paginator.addLine("");
        if (!this.hasAssignment()) {
            paginator.sendPage(sender, page);
            return;
        }
        boolean entriesPresent = false;
        paginator.addLine(ChatColor.GRAY + "Interact Scripts:");
        paginator.addLine("<e>Key: <a>Priority  <b>Name");
        if (assignmentScript.contains("INTERACT SCRIPTS")) {
            entriesPresent = true;
            for (String scriptEntry : assignmentScript.getStringList("INTERACT SCRIPTS")) {
                String[] split = scriptEntry.split(" ", 2);
                if (split.length == 2 && aH.matchesInteger(split[0])) {
                    paginator.addLine("<a>" + split[0] + "<b> " + split[1]);
                    continue;
                }
                paginator.addLine("<b>" + scriptEntry);
            }
        }
        if (!entriesPresent) {
            paginator.addLine("<c>No Interact Scripts assigned.");
        }
        paginator.addLine("");
        if (!entriesPresent) {
            if (!paginator.sendPage(sender, page)) {
                throw new CommandException("citizens.commands.page-missing");
            }
            return;
        }
        entriesPresent = false;
        paginator.addLine(ChatColor.GRAY + "Scheduled Scripts:");
        paginator.addLine("<e>Key: <a>Time  <b>Name");
        if (assignmentScript.contains("SCHEDULED ACTIVITIES")) {
            entriesPresent = true;
            for (String scriptEntry : assignmentScript.getStringList("SCHEDULED ACTIVITIES")) {
                paginator.addLine("<a>" + scriptEntry.split(" ")[0] + "<b> " + scriptEntry.split(" ", 2)[1]);
            }
        }
        if (!entriesPresent) {
            paginator.addLine("<c>No scheduled scripts activities.");
        }
        paginator.addLine("");
        entriesPresent = false;
        paginator.addLine(ChatColor.GRAY + "Actions:");
        paginator.addLine("<e>Key: <a>Action name  <b>Script Size");
        if (assignmentScript.contains("ACTIONS")) {
            entriesPresent = true;
        }
        if (entriesPresent) {
            for (StringHolder action : assignmentScript.getConfigurationSection("ACTIONS").getKeys(false)) {
                paginator.addLine("<a>" + action.str + " <b>" + assignmentScript.getStringList("ACTIONS." + action.str).size());
            }
        } else {
            paginator.addLine("<c>No actions defined in the assignment.");
        }
        paginator.addLine("");
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", new Object[]{page});
        }
    }

    public void onSpawn(NPCSpawnEvent event) {
        if (event.getNPC().getId() == this.npc.getId()) {
            this.entityId = this.npc.getEntity().getUniqueId();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(EntityDeathEvent deathEvent) {
        if (!deathEvent.getEntity().getUniqueId().equals(this.entityId)) {
            return;
        }
        EntityDamageEvent event = deathEvent.getEntity().getLastDamageCause();
        String deathCause = event == null ? "unknown" : CoreUtilities.toLowerCase(event.getCause().toString()).replace('_', ' ');
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("damage", new Element(event == null ? 0.0 : event.getDamage()));
        context.put("death_cause", new Element(deathCause));
        dPlayer player = null;
        if (event instanceof EntityDamageByEntityEvent) {
            ProjectileSource shooter;
            Entity killerEntity = ((EntityDamageByEntityEvent)event).getDamager();
            context.put("killer", new dEntity(killerEntity));
            if (killerEntity instanceof Player) {
                player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)((Player)killerEntity));
            } else if (killerEntity instanceof Projectile && (shooter = ((Projectile)killerEntity).getShooter()) != null && shooter instanceof LivingEntity) {
                context.put("shooter", new dEntity((Entity)((LivingEntity)shooter)));
                if (shooter instanceof Player) {
                    player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)((Player)shooter));
                }
                DenizenAPI.getDenizenNPC(this.npc).action("death by " + ((LivingEntity)shooter).getType().toString(), player, context);
            }
            DenizenAPI.getDenizenNPC(this.npc).action("death by entity", player, context);
            DenizenAPI.getDenizenNPC(this.npc).action("death by " + killerEntity.getType().toString(), player, context);
        } else if (event instanceof EntityDamageByBlockEvent) {
            DenizenAPI.getDenizenNPC(this.npc).action("death by block", player, context);
        }
        DenizenAPI.getDenizenNPC(this.npc).action("death", player, context);
        DenizenAPI.getDenizenNPC(this.npc).action("death by " + deathCause, player, context);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onHit(EntityDamageByEntityEvent event) {
        if (!this.npc.isSpawned()) {
            return;
        }
        if (event.getDamager() != this.npc.getEntity()) {
            if (event.getDamager() instanceof Projectile) {
                if (((Projectile)event.getDamager()).getShooter() != this.npc.getEntity()) {
                    return;
                }
            } else {
                return;
            }
        }
        dPlayer player = null;
        if (event.getEntity() instanceof Player) {
            player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)((Player)event.getEntity()));
        }
        DenizenAPI.getDenizenNPC(this.npc).action("hit", player);
        DenizenAPI.getDenizenNPC(this.npc).action("hit on " + event.getEntityType().name(), player);
        if (event.getEntity() instanceof LivingEntity && ((LivingEntity)event.getEntity()).getHealth() - event.getFinalDamage() <= 0.0) {
            DenizenAPI.getDenizenNPC(this.npc).action("kill", player);
            DenizenAPI.getDenizenNPC(this.npc).action("kill of " + event.getEntityType().name(), player);
        }
    }
}

