/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.blocks.FakeBlock;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class dChunk
implements dObject,
Adjustable {
    int chunkX;
    int chunkZ;
    dWorld world;
    Chunk cachedChunk;
    String prefix = "Chunk";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static dChunk valueOf(String string) {
        return dChunk.valueOf(string, null);
    }

    @Fetchable(value="ch")
    public static dChunk valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        String[] parts = (string = CoreUtilities.toLowerCase(string).replace("ch@", "")).split(",");
        if (parts.length == 3) {
            try {
                return new dChunk(dWorld.valueOf(parts[2], context), Integer.valueOf(parts[0]), Integer.valueOf(parts[1]));
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    net.aufdemrand.denizen.utilities.debugging.dB.log("Minor: valueOf dChunk returning null: ch@" + string);
                }
                return null;
            }
        }
        if (context == null || context.debug) {
            net.aufdemrand.denizen.utilities.debugging.dB.log("Minor: valueOf dChunk unable to handle malformed format: ch@" + string);
        }
        return null;
    }

    public static boolean matches(String string) {
        return CoreUtilities.toLowerCase(string).startsWith("ch@");
    }

    public Chunk getChunk() {
        if (this.cachedChunk == null) {
            this.cachedChunk = this.world.getWorld().getChunkAt(this.chunkX, this.chunkZ);
        }
        return this.cachedChunk;
    }

    public dChunk(Chunk chunk) {
        this.cachedChunk = chunk;
        this.world = new dWorld(chunk.getWorld());
        this.chunkX = chunk.getX();
        this.chunkZ = chunk.getZ();
    }

    public dChunk(dWorld world, int x, int z) {
        this.world = world;
        this.chunkX = x;
        this.chunkZ = z;
    }

    public dChunk(Location location) {
        this.world = new dWorld(location.getWorld());
        this.chunkX = location.getBlockX() >> 4;
        this.chunkZ = location.getBlockZ() >> 4;
    }

    public dLocation getCenter() {
        return new dLocation(this.getWorld(), this.getX() * 16 + 8, 128.0, this.getZ() * 16 + 8);
    }

    public int getX() {
        return this.chunkX;
    }

    public int getZ() {
        return this.chunkZ;
    }

    public World getWorld() {
        return this.world.getWorld();
    }

    public ChunkSnapshot getSnapshot() {
        return this.getChunk().getChunkSnapshot();
    }

    public int[] getHeightMap() {
        return NMSHandler.getInstance().getChunkHelper().getHeightMap(this.getChunk());
    }

    @Override
    public String getObjectType() {
        return "Chunk";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dChunk setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String identify() {
        return "ch@" + this.getX() + ',' + this.getZ() + ',' + this.getWorld().getName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public boolean isLoaded() {
        return this.world.getWorld().isChunkLoaded(this.chunkX, this.chunkZ);
    }

    public static void registerTags() {
        dChunk.registerTag("add", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("The tag ch@chunk.add[<#>,<#>] must have a value.");
                    return null;
                }
                List<String> coords = CoreUtilities.split(attribute.getContext(1), ',');
                if (coords.size() < 2) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("The tag ch@chunk.add[<#>,<#>] requires two values!");
                    return null;
                }
                int x = aH.getIntegerFrom(coords.get(0));
                int z = aH.getIntegerFrom(coords.get(1));
                dChunk chunk = (dChunk)object;
                return new dChunk(chunk.world, chunk.chunkX + x, chunk.chunkZ + z).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("sub", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("The tag ch@chunk.add[<#>,<#>] must have a value.");
                    return null;
                }
                List<String> coords = CoreUtilities.split(attribute.getContext(1), ',');
                if (coords.size() < 2) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("The tag ch@chunk.sub[<#>,<#>] requires two values!");
                    return null;
                }
                int x = aH.getIntegerFrom(coords.get(0));
                int z = aH.getIntegerFrom(coords.get(1));
                dChunk chunk = (dChunk)object;
                return new dChunk(chunk.world, chunk.chunkX - x, chunk.chunkZ - z).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("is_loaded", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dChunk)object).isLoaded()).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("x", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dChunk)object).chunkX).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("z", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dChunk)object).chunkZ).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("world", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return ((dChunk)object).world.getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("cuboid", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dChunk chunk = (dChunk)object;
                return new dCuboid(new Location(chunk.getWorld(), (double)(chunk.getX() * 16), 0.0, (double)(chunk.getZ() * 16)), new Location(chunk.getWorld(), (double)(chunk.getX() * 16 + 15), 255.0, (double)(chunk.getZ() * 16 + 15))).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("entities", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList entities = new dList();
                if (((dChunk)object).isLoaded()) {
                    for (Entity ent : ((dChunk)object).getChunk().getEntities()) {
                        entities.addObject(new dEntity(ent).getDenizenObject());
                    }
                }
                return entities.getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("living_entities", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList entities = new dList();
                if (((dChunk)object).isLoaded()) {
                    for (Entity ent : ((dChunk)object).getChunk().getEntities()) {
                        if (!(ent instanceof LivingEntity)) continue;
                        entities.addObject(new dEntity(ent).getDenizenObject());
                    }
                }
                return entities.getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("players", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList entities = new dList();
                if (((dChunk)object).isLoaded()) {
                    for (Entity ent : ((dChunk)object).getChunk().getEntities()) {
                        if (!dEntity.isPlayer(ent)) continue;
                        entities.addObject(new dPlayer((Player)ent));
                    }
                }
                return entities.getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("height_map", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                int[] heightMap = ((dChunk)object).getHeightMap();
                ArrayList<String> height_map = new ArrayList<String>(heightMap.length);
                for (int i : heightMap) {
                    height_map.add(String.valueOf(i));
                }
                return new dList((List<String>)height_map).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("average_height", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                int[] heightMap;
                int sum = 0;
                for (int i : heightMap = ((dChunk)object).getHeightMap()) {
                    sum += i;
                }
                return new Element((double)sum / (double)heightMap.length).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("is_flat", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                int tolerance = attribute.hasContext(1) && aH.matchesInteger(attribute.getContext(1)) ? Integer.valueOf(attribute.getContext(1)) : 2;
                int[] heightMap = ((dChunk)object).getHeightMap();
                int x = heightMap[0];
                for (int i : heightMap) {
                    if (Math.abs(x - i) <= tolerance) continue;
                    return new Element(false).getAttribute(attribute.fulfill(1));
                }
                return new Element(true).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("surface_blocks", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList surface_blocks = new dList();
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        surface_blocks.add(new dLocation(((dChunk)object).getChunk().getBlock(x, ((dChunk)object).getSnapshot().getHighestBlockYAt(x, z) - 1, z).getLocation()).identify());
                    }
                }
                return surface_blocks.getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("spawn_slimes", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dChunk chunk = (dChunk)object;
                Random random = new Random(chunk.getWorld().getSeed() + (long)(chunk.getX() * chunk.getX() * 4987142) + (long)(chunk.getX() * 5947611) + (long)(chunk.getZ() * chunk.getZ()) * 4392871L + (long)(chunk.getZ() * 389711) ^ 0x3AD8025FL);
                return new Element(random.nextInt(10) == 0).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element("Chunk").getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        net.aufdemrand.denizen.utilities.debugging.dB.echoError("Cannot apply properties to a chunk!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("unload")) {
            this.getChunk().unload(true);
        }
        if (mechanism.matches("unload_safely")) {
            net.aufdemrand.denizen.utilities.debugging.dB.echoError("Mechanism 'dChunk.unload_safely' is not valid: It is never safe to remove a chunk in use.");
            this.getChunk().unload(true);
        }
        if (mechanism.matches("unload_without_saving")) {
            this.getChunk().unload(false);
        }
        if (mechanism.matches("load")) {
            this.getChunk().load(true);
        }
        if (mechanism.matches("regenerate")) {
            this.getWorld().regenerateChunk(this.getX(), this.getZ());
        }
        if (mechanism.matches("refresh_chunk")) {
            final int chunkX = this.getX();
            final int chunkZ = this.getZ();
            this.getWorld().refreshChunk(chunkX, chunkZ);
            new BukkitRunnable(){

                public void run() {
                    for (Map<dLocation, FakeBlock> blocks : FakeBlock.getBlocks().values()) {
                        for (Map.Entry<dLocation, FakeBlock> locBlock : blocks.entrySet()) {
                            dLocation location = locBlock.getKey();
                            if (Math.floor(location.getX() / 16.0) != (double)chunkX || Math.floor(location.getZ() / 16.0) != (double)chunkZ) continue;
                            locBlock.getValue().updateBlock();
                        }
                    }
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 2L);
        }
        if (mechanism.matches("refresh_chunk_sections")) {
            NMSHandler.getInstance().getChunkHelper().refreshChunkSections(this.getChunk());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

