/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.nms.abstracts.ImprovedOfflinePlayer;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.scripts.containers.core.InventoryScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InventoryScriptHelper;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.notable.Notable;
import net.aufdemrand.denizencore.objects.notable.Note;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;

public class dInventory
implements dObject,
Notable,
Adjustable {
    static final Pattern inventory_by_type = Pattern.compile("(in@)(npc|player|enderchest|workbench|entity|location|generic)\\[(.+?)\\]", 2);
    static final Pattern inventory_by_script = Pattern.compile("(in@)(.+)", 2);
    public static final int maxSlots = 54;
    public static final String[] idTypes = new String[]{"npc", "player", "crafting", "enderchest", "workbench", "entity", "location", "generic"};
    public String notableColors = null;
    public static int inventoryNameNotableRequired = NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2) ? 9 : 6;
    public static int inventoryNameNotableMax = 32 - inventoryNameNotableRequired;
    String idType = null;
    String idHolder = null;
    private Inventory inventory = null;
    private String prefix = this.getObjectType();
    private ArrayList<Mechanism> mechanisms = new ArrayList();

    public static dInventory mirrorBukkitInventory(Inventory inventory) {
        if (InventoryScriptHelper.tempInventoryScripts.containsKey(inventory)) {
            return new dInventory(inventory).setIdentifiers("script", InventoryScriptHelper.tempInventoryScripts.get(inventory));
        }
        String title = NMSHandler.getInstance().getTitle(inventory);
        if (InventoryScriptHelper.notableInventories.containsKey(title)) {
            return InventoryScriptHelper.notableInventories.get(title);
        }
        for (Map.Entry<UUID, PlayerInventory> entry : ImprovedOfflinePlayer.offlineInventories.entrySet()) {
            if (!entry.getValue().equals(inventory)) continue;
            return new dInventory(NMSHandler.getInstance().getPlayerHelper().getOfflineData(entry.getKey()));
        }
        for (Map.Entry<UUID, PlayerInventory> entry : ImprovedOfflinePlayer.offlineEnderChests.entrySet()) {
            if (!((Inventory)entry.getValue()).equals(inventory)) continue;
            return new dInventory(NMSHandler.getInstance().getPlayerHelper().getOfflineData(entry.getKey()), true);
        }
        return new dInventory(inventory);
    }

    @Override
    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    @Override
    @Note(value="Inventories")
    public String getSaveObject() {
        return "in@" + this.idType + PropertyParser.getPropertiesString(this);
    }

    @Override
    public void makeUnique(String id) {
        String colors;
        String title = NMSHandler.getInstance().getTitle(this.inventory);
        if (title == null || title.startsWith("container.")) {
            title = this.inventory.getType().getDefaultTitle();
        }
        if (title.length() > inventoryNameNotableMax) {
            title = title.substring(0, title.charAt(inventoryNameNotableMax - 1) == '\u00a7' ? inventoryNameNotableMax - 1 : inventoryNameNotableMax);
        }
        int x = 0;
        do {
            if (++x > 5000) {
                dB.echoError("Inventory note failed - too many notes already!");
                return;
            }
            colors = NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2) ? Utilities.generateRandomColorsWithDots(3) : Utilities.generateRandomColors(3);
        } while (InventoryScriptHelper.notableInventories.containsKey(title + colors));
        this.notableColors = colors;
        ItemStack[] contents = this.inventory.getContents();
        this.inventory = this.getInventoryType() == InventoryType.CHEST ? Bukkit.getServer().createInventory(null, this.inventory.getSize(), title + colors) : Bukkit.getServer().createInventory(null, this.inventory.getType(), title + colors);
        this.inventory.setContents(contents);
        InventoryScriptHelper.notableInventories.put(title + colors, this);
        this.idType = null;
        this.idHolder = null;
        this.loadIdentifiers();
        NotableManager.saveAs(this, id);
    }

    @Override
    public void forget() {
        this.notableColors = null;
        NotableManager.remove(this.idHolder);
    }

    @Fetchable(value="in")
    public static dInventory valueOf(String string, TagContext context) {
        if (context == null) {
            return dInventory.valueOf(string, null, null);
        }
        return dInventory.valueOf(string, ((BukkitTagContext)context).player, ((BukkitTagContext)context).npc);
    }

    public static dInventory valueOf(String string, dPlayer player, dNPC npc) {
        return dInventory.valueOf(string, player, npc, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static dInventory valueOf(String string, dPlayer player, dNPC npc, boolean silent) {
        if (string == null) {
            return null;
        }
        Matcher m = ObjectFetcher.DESCRIBED_PATTERN.matcher(string);
        if (m.matches()) {
            return ObjectFetcher.getObjectFrom(dInventory.class, string, new BukkitTagContext(player, npc, false, null, false, null));
        }
        m = inventory_by_script.matcher(string);
        if (m.matches()) {
            if (ScriptRegistry.containsScript(m.group(2), InventoryScriptContainer.class)) {
                return ScriptRegistry.getScriptContainerAs(m.group(2), InventoryScriptContainer.class).getInventoryFrom(player, npc);
            }
            if (NotableManager.isSaved(m.group(2)) && NotableManager.isType(m.group(2), dInventory.class)) {
                return (dInventory)NotableManager.getSavedObject(m.group(2));
            }
            for (String idType : idTypes) {
                if (!m.group(2).equalsIgnoreCase(idType)) continue;
                return new dInventory(m.group(2));
            }
        }
        if ((m = inventory_by_type.matcher(string)).matches()) {
            String type = CoreUtilities.toLowerCase(m.group(2));
            String holder = m.group(3);
            if (type.equals("generic")) {
                aH.Argument arg = aH.Argument.valueOf(holder);
                if (arg.matchesEnum((Enum<?>[])InventoryType.values())) {
                    return new dInventory(InventoryType.valueOf((String)holder.toUpperCase()));
                }
                if (arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                    return new dInventory(arg.asElement().asInt());
                }
                if (!silent) {
                    dB.echoError("That type of inventory does not exist!");
                }
            } else if (type.equals("npc")) {
                if (dNPC.matches(holder)) {
                    return dNPC.valueOf(holder).getDenizenInventory();
                }
            } else if (type.equals("crafting")) {
                if (dPlayer.matches(holder)) {
                    dPlayer holderPlayer = dPlayer.valueOf(holder);
                    Inventory opened = holderPlayer.getPlayerEntity().getOpenInventory().getTopInventory();
                    if (!(opened instanceof CraftingInventory)) return dPlayer.valueOf(holder).getInventory();
                    return new dInventory(opened);
                }
            } else if (type.equals("player")) {
                if (dPlayer.matches(holder)) {
                    return dPlayer.valueOf(holder).getInventory();
                }
            } else if (type.equals("workbench")) {
                if (dPlayer.matches(holder)) {
                    dInventory workbench = dPlayer.valueOf(holder).getWorkbench();
                    if (workbench != null) return workbench;
                    if (!silent) {
                        dB.echoError("Value of dInventory returning null (" + string + "). Specified player does not have an open workbench.");
                    }
                }
            } else if (type.equals("enderchest")) {
                if (dPlayer.matches(holder)) {
                    return dPlayer.valueOf(holder).getEnderChest();
                }
            } else if (type.equals("entity")) {
                if (dEntity.matches(holder)) {
                    return dEntity.valueOf(holder).getInventory();
                }
            } else if (type.equals("location") && dLocation.matches(holder)) {
                return dLocation.valueOf(holder).getInventory();
            }
            if (silent) return null;
            dB.echoError("Value of dInventory returning null. Invalid " + type + " specified: " + holder);
            return null;
        }
        if (silent) return null;
        dB.echoError("Value of dInventory returning null. Invalid dInventory specified: " + string);
        return null;
    }

    public static boolean matches(String arg) {
        if (CoreUtilities.toLowerCase(arg).startsWith("in@")) {
            return true;
        }
        String tid = arg;
        if (arg.contains("[")) {
            tid = arg.substring(0, arg.indexOf(91));
        }
        if (new Element(tid).matchesEnum((Enum[])InventoryType.values())) {
            return true;
        }
        if (ScriptRegistry.containsScript(tid, InventoryScriptContainer.class)) {
            return true;
        }
        if (NotableManager.isSaved(tid) && NotableManager.isType(tid, dInventory.class)) {
            return true;
        }
        for (String idType : idTypes) {
            if (!tid.equalsIgnoreCase(idType)) continue;
            return true;
        }
        return false;
    }

    public dInventory(Inventory inventory) {
        this.inventory = inventory;
        this.loadIdentifiers();
    }

    public dInventory(Inventory inventory, InventoryHolder holder) {
        this.inventory = inventory;
        this.loadIdentifiers(holder);
    }

    public dInventory(InventoryHolder holder) {
        this.inventory = holder.getInventory();
        this.loadIdentifiers();
    }

    public dInventory(ItemStack[] items) {
        this.inventory = Bukkit.getServer().createInventory(null, (int)Math.ceil((double)items.length / 9.0) * 9);
        this.setContents(items);
        this.loadIdentifiers();
    }

    public dInventory(ImprovedOfflinePlayer offlinePlayer) {
        this(offlinePlayer, false);
    }

    public dInventory(ImprovedOfflinePlayer offlinePlayer, boolean isEnderChest) {
        this.inventory = isEnderChest ? offlinePlayer.getEnderChest() : offlinePlayer.getInventory();
        this.setIdentifiers(isEnderChest ? "enderchest" : "player", "p@" + offlinePlayer.getUniqueId());
    }

    public dInventory(int size, String title) {
        if (size <= 0 || size % 9 != 0) {
            dB.echoError("InventorySize must be multiple of 9, and greater than 0.");
            return;
        }
        this.inventory = Bukkit.getServer().createInventory(null, size, title);
        this.loadIdentifiers();
    }

    public dInventory(InventoryType type) {
        this.inventory = Bukkit.getServer().createInventory(null, type);
        this.loadIdentifiers();
    }

    public dInventory(int size) {
        this(size, "Chest");
    }

    public dInventory(String idType) {
        this.idType = CoreUtilities.toLowerCase(idType);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
        this.loadIdentifiers();
    }

    public void setInventory(Inventory inventory, dPlayer player) {
        this.inventory = inventory;
        this.idHolder = player.identify();
    }

    public void setTitle(String title) {
        if (!this.getIdType().equals("generic") && !this.getIdType().equals("script") || title == null) {
            return;
        }
        if (this.inventory != null && NMSHandler.getInstance().getTitle(this.inventory).equals(title)) {
            return;
        }
        if (this.inventory == null) {
            this.inventory = Bukkit.getServer().createInventory(null, 54, title);
            this.loadIdentifiers();
            return;
        }
        if (this.notableColors != null) {
            title = title + this.notableColors;
            InventoryScriptHelper.notableInventories.remove(NMSHandler.getInstance().getTitle(this.inventory));
            InventoryScriptHelper.notableInventories.put(title, this);
        }
        ItemStack[] contents = this.inventory.getContents();
        this.inventory = this.inventory.getType() == InventoryType.CHEST ? Bukkit.getServer().createInventory(null, this.inventory.getSize(), title) : Bukkit.getServer().createInventory(null, this.inventory.getType(), title);
        this.inventory.setContents(contents);
        this.loadIdentifiers();
    }

    public boolean containsItem(dItem item, int amount) {
        if (item == null) {
            return false;
        }
        item = new dItem(item.getItemStack().clone());
        item.setAmount(1);
        String myItem = CoreUtilities.toLowerCase(item.getFullString());
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            ItemStack is = this.inventory.getItem(i);
            if (is == null || item.getMaterial().getMaterial() != is.getType()) continue;
            is = is.clone();
            int count = is.getAmount();
            is.setAmount(1);
            String newItem = CoreUtilities.toLowerCase(new dItem(is).getFullString());
            if (!myItem.equals(newItem) || !(count <= amount ? (amount -= count) == 0 : count > amount)) continue;
            return true;
        }
        return false;
    }

    public boolean removeItem(dItem item, int amount) {
        if (item == null) {
            return false;
        }
        item.setAmount(1);
        String myItem = CoreUtilities.toLowerCase(item.getFullString());
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            ItemStack is = this.inventory.getItem(i);
            if (is == null) continue;
            is = is.clone();
            int count = is.getAmount();
            is.setAmount(1);
            String newItem = CoreUtilities.toLowerCase(dItem.valueOf(new dItem(is).getFullString(), false).getFullString());
            if (!myItem.equals(newItem)) continue;
            if (count <= amount) {
                this.inventory.setItem(i, null);
                if ((amount -= count) != 0) continue;
                return true;
            }
            if (count <= amount) continue;
            is.setAmount(count - amount);
            this.inventory.setItem(i, is);
            return true;
        }
        return false;
    }

    public void setSize(int size) {
        if (!this.getIdType().equals("generic")) {
            return;
        }
        if (size <= 0 || size % 9 != 0) {
            dB.echoError("InventorySize must be multiple of 9, and greater than 0.");
            return;
        }
        if (this.inventory == null) {
            this.inventory = Bukkit.getServer().createInventory(null, size, "Chest");
            this.loadIdentifiers();
            return;
        }
        int oldSize = this.inventory.getSize();
        ItemStack[] oldContents = this.inventory.getContents();
        ItemStack[] newContents = new ItemStack[size];
        if (oldSize > size) {
            for (int i = 0; i < size; ++i) {
                newContents[i] = oldContents[i];
            }
        } else {
            newContents = oldContents;
        }
        String title = NMSHandler.getInstance().getTitle(this.inventory);
        this.inventory = Bukkit.getServer().createInventory(null, size, title != null ? title : this.inventory.getType().getDefaultTitle());
        this.inventory.setContents(newContents);
        this.loadIdentifiers();
    }

    private void loadIdentifiers() {
        this.loadIdentifiers(this.inventory.getHolder());
    }

    private void loadIdentifiers(InventoryHolder holder) {
        if (this.inventory == null) {
            return;
        }
        if (holder != null) {
            if (holder instanceof dNPC) {
                this.idType = "npc";
                this.idHolder = ((dNPC)holder).identify();
                return;
            }
            if (holder instanceof Player) {
                if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)((Player)holder))) {
                    this.idType = "npc";
                    this.idHolder = dNPC.fromEntity((Entity)((Player)holder)).identify();
                    return;
                }
                if (this.inventory.getType() == InventoryType.CRAFTING) {
                    this.idType = "crafting";
                }
                this.idType = this.inventory.getType() == InventoryType.ENDER_CHEST ? "enderchest" : (this.inventory.getType() == InventoryType.WORKBENCH ? "workbench" : "player");
                this.idHolder = new dPlayer((Player)holder).identify();
                return;
            }
            if (holder instanceof Entity) {
                this.idType = "entity";
                this.idHolder = new dEntity((Entity)holder).identify();
                return;
            }
            this.idType = "location";
            try {
                this.idHolder = this.getLocation(holder).identify();
            }
            catch (NullPointerException e) {
                this.idHolder = "null";
            }
            return;
        }
        if (this.getIdType().equals("player")) {
            for (Map.Entry<UUID, PlayerInventory> inv : ImprovedOfflinePlayer.offlineInventories.entrySet()) {
                if (!inv.getValue().equals(this.inventory)) continue;
                this.idHolder = new dPlayer(inv.getKey()).identify();
                return;
            }
        } else if (this.getIdType().equals("enderchest")) {
            for (Map.Entry<UUID, Inventory> inv : ImprovedOfflinePlayer.offlineEnderChests.entrySet()) {
                if (!inv.getValue().equals(this.inventory)) continue;
                this.idHolder = new dPlayer(inv.getKey()).identify();
                return;
            }
        } else if (this.getIdType().equals("script") && InventoryScriptHelper.tempInventoryScripts.containsKey(this.inventory)) {
            this.idHolder = InventoryScriptHelper.tempInventoryScripts.get(this.inventory);
            return;
        }
        this.idType = "generic";
        this.idHolder = this.getInventory().getType().name();
    }

    public dInventory setIdentifiers(String type, String holder) {
        this.idType = type;
        this.idHolder = holder;
        return this;
    }

    public void setIdType(String type) {
        this.idType = type;
    }

    public String getIdType() {
        return this.idType == null ? "" : this.idType;
    }

    public String getIdHolder() {
        return this.idHolder == null ? "" : this.idHolder;
    }

    public dLocation getLocation() {
        return this.getLocation(this.inventory.getHolder());
    }

    public dLocation getLocation(InventoryHolder holder) {
        if (this.inventory != null && holder != null) {
            if (holder instanceof BlockState) {
                return new dLocation(((BlockState)holder).getLocation());
            }
            if (holder instanceof DoubleChest) {
                return new dLocation(((DoubleChest)holder).getLocation());
            }
            if (holder instanceof Entity) {
                return new dLocation(((Entity)holder).getLocation());
            }
            if (holder instanceof dNPC) {
                dNPC npc = (dNPC)holder;
                if (npc.getLocation() == null) {
                    return new dLocation(((dNPC)holder).getCitizen().getStoredLocation());
                }
                return npc.getLocation();
            }
        }
        return null;
    }

    public ItemStack[] getContents() {
        if (this.inventory != null) {
            return this.inventory.getContents();
        }
        return new ItemStack[0];
    }

    public ItemStack[] getStorageContents() {
        if (this.inventory != null) {
            return this.inventory.getStorageContents();
        }
        return new ItemStack[0];
    }

    public dList getEquipment() {
        ItemStack[] equipment = null;
        if (this.inventory instanceof PlayerInventory) {
            equipment = ((PlayerInventory)this.inventory).getArmorContents();
        } else if (this.inventory instanceof HorseInventory) {
            equipment = new ItemStack[]{((HorseInventory)this.inventory).getSaddle(), ((HorseInventory)this.inventory).getArmor()};
        }
        if (equipment == null) {
            return null;
        }
        dList equipmentList = new dList();
        for (ItemStack item : equipment) {
            equipmentList.add(new dItem(item).identify());
        }
        return equipmentList;
    }

    public InventoryType getInventoryType() {
        return this.inventory.getType();
    }

    public int getSize() {
        return this.inventory.getSize();
    }

    public void remove(ItemStack item) {
        this.inventory.remove(item);
    }

    public void setContents(ItemStack[] contents) {
        this.inventory.setContents(contents);
    }

    public void setContents(dList list, TagContext context) {
        int size;
        if (this.inventory == null) {
            size = (int)Math.ceil((double)list.size() / 9.0) * 9;
            if (size == 0) {
                size = 9;
            }
            this.inventory = Bukkit.getServer().createInventory(null, size);
            this.loadIdentifiers();
        } else {
            size = this.inventory.getSize();
        }
        ItemStack[] contents = new ItemStack[size];
        int filled = 0;
        for (dItem item : list.filter(dItem.class, context)) {
            contents[filled] = item.getItemStack();
            ++filled;
        }
        ItemStack air = new ItemStack(Material.AIR);
        while (filled < size) {
            contents[filled] = air;
            ++filled;
        }
        this.inventory.setContents(contents);
        if (Depends.citizens != null && dNPC.matches(this.idHolder)) {
            dNPC.valueOf(this.idHolder).getInventoryTrait().setContents(contents);
        }
    }

    public boolean update() {
        if (this.getIdType().equals("player")) {
            dPlayer.valueOf(this.idHolder).getPlayerEntity().updateInventory();
            return true;
        }
        return false;
    }

    public int firstPartial(int startSlot, ItemStack item) {
        ItemStack[] inventory = this.getContents();
        if (item == null) {
            return -1;
        }
        for (int i = startSlot; i < inventory.length; ++i) {
            ItemStack item1 = inventory[i];
            if (item1 == null || item1.getAmount() >= item.getMaxStackSize() || !item1.isSimilar(item)) continue;
            return i;
        }
        return -1;
    }

    public int firstEmpty(int startSlot) {
        ItemStack[] inventory = this.getStorageContents();
        for (int i = startSlot; i < inventory.length; ++i) {
            if (inventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    public dInventory add(int slot, ItemStack ... items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (item == null) continue;
            int amount = item.getAmount();
            int max = item.getMaxStackSize();
            while (true) {
                int firstPartial;
                if ((firstPartial = this.firstPartial(slot, item)) == -1) {
                    int firstFree = this.firstEmpty(slot);
                    if (firstFree == -1) continue block0;
                    if (amount > max) {
                        ItemStack clone = item.clone();
                        clone.setAmount(max);
                        this.inventory.setItem(firstFree, clone);
                        item.setAmount(amount -= max);
                        continue;
                    }
                    this.inventory.setItem(firstFree, item);
                    continue block0;
                }
                ItemStack partialItem = this.inventory.getItem(firstPartial);
                int partialAmount = partialItem.getAmount();
                int total = amount + partialAmount;
                if (total <= max) {
                    partialItem.setAmount(total);
                    continue block0;
                }
                partialItem.setAmount(max);
                amount = total - max;
                item.setAmount(amount);
            }
        }
        return this;
    }

    public List<ItemStack> addWithLeftovers(int slot, boolean keepMaxStackSize, ItemStack ... items) {
        if (this.inventory == null || items == null) {
            return null;
        }
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (item == null) continue;
            int amount = item.getAmount();
            int max = keepMaxStackSize ? item.getMaxStackSize() : 64;
            while (true) {
                int firstPartial;
                if ((firstPartial = this.firstPartial(slot, item)) == -1) {
                    int firstFree = this.firstEmpty(slot);
                    if (firstFree == -1) {
                        leftovers.add(item);
                        continue block0;
                    }
                    if (amount > max) {
                        ItemStack clone = item.clone();
                        clone.setAmount(max);
                        this.inventory.setItem(firstFree, clone);
                        item.setAmount(amount -= max);
                        continue;
                    }
                    this.inventory.setItem(firstFree, item);
                    continue block0;
                }
                ItemStack partialItem = this.inventory.getItem(firstPartial);
                int partialAmount = partialItem.getAmount();
                int total = amount + partialAmount;
                if (total <= max) {
                    partialItem.setAmount(total);
                    continue block0;
                }
                partialItem.setAmount(max);
                amount = total - max;
                item.setAmount(amount);
            }
        }
        return leftovers;
    }

    public List<ItemStack> setWithLeftovers(int slot, ItemStack ... items) {
        if (this.inventory == null || items == null) {
            return null;
        }
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            try {
                this.inventory.setItem(i + slot, item);
                continue;
            }
            catch (Exception e) {
                leftovers.add(i + slot, item);
            }
        }
        return leftovers;
    }

    public int countByMaterial(Material material) {
        if (this.inventory == null) {
            return 0;
        }
        int qty = 0;
        for (ItemStack invStack : this.inventory) {
            if (invStack == null || invStack.getType() != material) continue;
            qty += invStack.getAmount();
        }
        return qty;
    }

    public int countByScriptName(String scriptName) {
        if (this.inventory == null) {
            return 0;
        }
        int qty = 0;
        for (ItemStack invStack : this.inventory) {
            dItem item;
            if (invStack == null || !(item = new dItem(invStack)).isItemscript() || !item.getScriptName().equalsIgnoreCase(scriptName)) continue;
            qty += invStack.getAmount();
        }
        return qty;
    }

    public int count(ItemStack item, boolean stacks) {
        if (this.inventory == null) {
            return 0;
        }
        int qty = 0;
        for (ItemStack invStack : this.inventory) {
            if (invStack == null || item != null && !invStack.isSimilar(item)) continue;
            qty += stacks ? 1 : invStack.getAmount();
        }
        return qty;
    }

    public dInventory keep(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        for (ItemStack invStack : this.inventory) {
            if (invStack == null) continue;
            boolean keep = false;
            for (ItemStack item : items) {
                if (!invStack.isSimilar(item)) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            this.remove(invStack);
        }
        return this;
    }

    public dInventory exclude(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        int oldCount = this.count(null, false);
        int newCount = -1;
        while (oldCount != newCount) {
            oldCount = newCount;
            newCount = this.remove(items).count(null, false);
        }
        return this;
    }

    public dInventory fill(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        int oldCount = this.count(null, false);
        int newCount = -1;
        while (oldCount != newCount) {
            oldCount = newCount;
            newCount = this.add(0, items).count(null, false);
        }
        return this;
    }

    public dInventory remove(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        for (ItemStack item : items) {
            if (item == null) continue;
            this.inventory.removeItem(new ItemStack[]{item.clone()});
        }
        return this;
    }

    public dInventory removeBook(String title, String author, int quantity) {
        if (this.inventory == null || title == null && author == null) {
            return this;
        }
        for (ItemStack invStack : this.inventory) {
            if (quantity == 0) break;
            if (invStack == null || !(invStack.getItemMeta() instanceof BookMeta)) continue;
            BookMeta invMeta = (BookMeta)invStack.getItemMeta();
            String invTitle = invMeta.getTitle();
            String invAuthor = invMeta.getAuthor();
            if (invTitle == null && title != null || invAuthor == null && author != null || invTitle == null || invAuthor == null || !dInventory.equalOrNull(invAuthor, author) || !dInventory.equalOrNull(invTitle, title)) continue;
            if (quantity - invStack.getAmount() < 0) {
                invStack.setAmount((quantity - invStack.getAmount()) * -1);
                continue;
            }
            this.inventory.removeItem(new ItemStack[]{invStack});
            quantity -= invStack.getAmount();
        }
        return this;
    }

    private static boolean equalOrNull(String a, String b) {
        return b == null || a == null || a.equalsIgnoreCase(b);
    }

    public void replace(dInventory destination) {
        if (this.inventory == null || destination == null) {
            return;
        }
        if (destination.getSize() < this.getSize()) {
            destination.clear();
            destination.add(0, this.getContents());
        } else {
            destination.setContents(this.getContents());
        }
    }

    public dInventory setSlots(int slot, ItemStack ... items) {
        return this.setSlots(slot, items, items.length);
    }

    public dInventory setSlots(int slot, ItemStack[] items, int c) {
        if (this.inventory == null || items == null) {
            return this;
        }
        for (int i = 0; i < c; ++i) {
            if (i >= items.length || items[i] == null) {
                this.inventory.setItem(slot + i, new ItemStack(Material.AIR));
            }
            ItemStack item = items[i];
            if (slot + i < 0 || slot + i >= this.inventory.getSize()) break;
            this.inventory.setItem(slot + i, item);
        }
        if (Depends.citizens != null && dNPC.matches(this.idHolder)) {
            dNPC.valueOf(this.idHolder).getInventoryTrait().setContents(this.inventory.getContents());
        }
        return this;
    }

    public void clear() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
    }

    @Override
    public String getObjectType() {
        return "Inventory";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dInventory setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "in@" + NotableManager.getSavedId(this);
        }
        return "in@" + (this.getIdType().equals("script") ? this.idHolder : this.idType + PropertyParser.getPropertiesString(this));
    }

    public String bestName() {
        if (this.isUnique()) {
            return NotableManager.getSavedId(this);
        }
        return this.getIdType().equals("script") || this.getIdType().equals("notable") ? this.idHolder : this.idType;
    }

    @Override
    public String identifySimple() {
        if (this.isUnique()) {
            return "in@" + NotableManager.getSavedId(this);
        }
        return "in@" + (this.getIdType().equals("script") || this.getIdType().equals("notable") ? this.idHolder : this.idType + "[" + this.idHolder + "]");
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("empty_slots")) {
            dInventory dummyInv;
            if (this.inventory.getType() == InventoryType.PLAYER) {
                dummyInv = new dInventory(Bukkit.createInventory(null, (InventoryType)InventoryType.CHEST));
                ItemStack[] contents = this.getStorageContents();
                dummyInv.setSize(contents.length);
                if (contents.length != dummyInv.getSize()) {
                    contents = Arrays.copyOf(contents, dummyInv.getSize());
                }
                dummyInv.setContents(contents);
            } else {
                dummyInv = new dInventory(this.inventory);
            }
            int full = dummyInv.count(null, true);
            return new Element(dummyInv.getSize() - full).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_fit") && attribute.hasContext(1)) {
            List<dItem> items = dList.valueOf(attribute.getContext(1)).filter(dItem.class, attribute.getScriptEntry());
            if (items == null || items.isEmpty()) {
                return null;
            }
            int attribs = 1;
            InventoryType type = this.inventory.getType();
            dInventory dummyInv = new dInventory(Bukkit.createInventory(null, (InventoryType)(type == InventoryType.PLAYER ? InventoryType.CHEST : type), (String)NMSHandler.getInstance().getTitle(this.inventory)));
            ItemStack[] contents = this.getStorageContents();
            if (dummyInv.getInventoryType() == InventoryType.CHEST) {
                dummyInv.setSize(contents.length);
            }
            if (contents.length != dummyInv.getSize()) {
                contents = Arrays.copyOf(contents, dummyInv.getSize());
            }
            dummyInv.setContents(contents);
            if (attribute.getAttribute(2).startsWith("count")) {
                attribs = 2;
                ItemStack toAdd = items.get(0).getItemStack().clone();
                int totalCount = 16384;
                toAdd.setAmount(totalCount);
                List<ItemStack> leftovers = dummyInv.addWithLeftovers(0, true, toAdd);
                int result = 0;
                if (leftovers.size() > 0) {
                    result += leftovers.get(0).getAmount();
                }
                return new Element(totalCount - result).getAttribute(attribute.fulfill(attribs));
            }
            if ((attribute.getAttribute(2).startsWith("quantity") || attribute.getAttribute(2).startsWith("qty")) && attribute.hasContext(2) && aH.matchesInteger(attribute.getContext(2))) {
                int qty = attribute.getIntContext(2);
                attribs = 2;
                items.get(0).setAmount(qty);
            }
            for (dItem itm : items) {
                List<ItemStack> leftovers = dummyInv.addWithLeftovers(0, true, itm.getItemStack());
                if (leftovers.isEmpty()) continue;
                return new Element(false).getAttribute(attribute.fulfill(attribs));
            }
            return new Element(true).getAttribute(attribute.fulfill(attribs));
        }
        if (attribute.startsWith("include") && attribute.hasContext(1) && dItem.matches(attribute.getContext(1))) {
            dItem item = dItem.valueOf(attribute.getContext(1), attribute.context);
            if (item == null) {
                return null;
            }
            int attribs = 1;
            int qty = 1;
            dInventory dummyInv = new dInventory(Bukkit.createInventory(null, (InventoryType)this.inventory.getType(), (String)NMSHandler.getInstance().getTitle(this.inventory)));
            if (this.inventory.getType() == InventoryType.CHEST) {
                dummyInv.setSize(this.inventory.getSize());
            }
            dummyInv.setContents(this.getContents());
            if ((attribute.getAttribute(2).startsWith("quantity") || attribute.getAttribute(2).startsWith("qty")) && attribute.hasContext(2) && aH.matchesInteger(attribute.getContext(2))) {
                qty = attribute.getIntContext(2);
                attribs = 2;
            }
            item.setAmount(qty);
            dummyInv.add(0, item.getItemStack());
            return dummyInv.getAttribute(attribute.fulfill(attribs));
        }
        if (attribute.startsWith("is_empty")) {
            boolean empty = true;
            for (ItemStack item : this.getStorageContents()) {
                if (item == null || item.getType() == Material.AIR) continue;
                empty = false;
                break;
            }
            return new Element(empty).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_full")) {
            boolean full = true;
            for (ItemStack item : this.getStorageContents()) {
                if (item != null && item.getType() != Material.AIR && item.getAmount() >= item.getMaxStackSize()) continue;
                full = false;
                break;
            }
            return new Element(full).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("contains.display") && attribute.hasContext(2)) {
            String search_string = attribute.getContext(2);
            boolean strict = false;
            if (CoreUtilities.toLowerCase(search_string).startsWith("strict:") && search_string.length() > 7) {
                strict = true;
                search_string = search_string.substring(7);
            }
            if (search_string.length() == 0) {
                return null;
            }
            int qty = 1;
            int attribs = 2;
            if ((attribute.getAttribute(3).startsWith("quantity") || attribute.getAttribute(3).startsWith("qty")) && attribute.hasContext(3) && aH.matchesInteger(attribute.getContext(3))) {
                qty = attribute.getIntContext(3);
                attribs = 3;
            }
            int found_items = 0;
            if (strict) {
                for (ItemStack item : this.getContents()) {
                    if (item != null && item.getType() == Material.WRITTEN_BOOK && ((BookMeta)item.getItemMeta()).getTitle().equalsIgnoreCase(search_string) ? (found_items += item.getAmount()) >= qty : item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equalsIgnoreCase(search_string) && (found_items += item.getAmount()) >= qty) break;
                }
            } else {
                for (ItemStack item : this.getContents()) {
                    if (item != null && item.getType() == Material.WRITTEN_BOOK && CoreUtilities.toLowerCase(((BookMeta)item.getItemMeta()).getTitle()).contains(CoreUtilities.toLowerCase(search_string)) ? (found_items += item.getAmount()) >= qty : item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && CoreUtilities.toLowerCase(item.getItemMeta().getDisplayName()).contains(CoreUtilities.toLowerCase(search_string)) && (found_items += item.getAmount()) >= qty) break;
                }
            }
            return new Element(found_items >= qty).getAttribute(attribute.fulfill(attribs));
        }
        if (attribute.startsWith("contains.lore") && attribute.hasContext(2)) {
            int found_items2;
            int attribs;
            int qty;
            block98: {
                String search_string = attribute.getContext(2);
                boolean strict = false;
                if (CoreUtilities.toLowerCase(search_string).startsWith("strict:")) {
                    strict = true;
                    search_string = search_string.substring(7);
                }
                if (search_string.length() == 0) {
                    return null;
                }
                dList lore = dList.valueOf(search_string);
                qty = 1;
                attribs = 2;
                if ((attribute.getAttribute(3).startsWith("quantity") || attribute.getAttribute(3).startsWith("qty")) && attribute.hasContext(3) && aH.matchesInteger(attribute.getContext(3))) {
                    qty = attribute.getIntContext(3);
                    attribs = 3;
                }
                found_items2 = 0;
                if (strict) {
                    for (ItemStack item : this.getContents()) {
                        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) continue;
                        List item_lore = item.getItemMeta().getLore();
                        if (lore.size() != item_lore.size()) continue;
                        for (int i = 0; i < item_lore.size() && ((String)lore.get(i)).equalsIgnoreCase((String)item_lore.get(i)); ++i) {
                            if (i != lore.size() || (found_items2 += item.getAmount()) < qty) {
                                continue;
                            }
                            break block98;
                        }
                    }
                } else {
                    for (ItemStack item : this.getContents()) {
                        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) continue;
                        List item_lore = item.getItemMeta().getLore();
                        int loreCount = 0;
                        block8: for (String line : lore) {
                            for (String item_line : item_lore) {
                                if (!CoreUtilities.toLowerCase(item_line).contains(CoreUtilities.toLowerCase(line))) continue;
                                ++loreCount;
                                continue block8;
                            }
                        }
                        if (loreCount != lore.size() || (found_items2 += item.getAmount()) < qty) {
                            continue;
                        }
                        break;
                    }
                }
            }
            return new Element(found_items2 >= qty).getAttribute(attribute.fulfill(attribs));
        }
        if (attribute.startsWith("contains.scriptname") && attribute.hasContext(2)) {
            ItemStack item;
            String scrName = attribute.getContext(2);
            int qty = 1;
            int attribs = 2;
            if ((attribute.getAttribute(3).startsWith("quantity") || attribute.getAttribute(3).startsWith("qty")) && attribute.hasContext(3) && aH.matchesInteger(attribute.getContext(3))) {
                qty = attribute.getIntContext(3);
                attribs = 3;
            }
            int found_items = 0;
            ItemStack[] itemStackArray = this.getContents();
            int found_items2 = itemStackArray.length;
            for (int i = 0; !(i >= found_items2 || (item = itemStackArray[i]) != null && scrName.equalsIgnoreCase(new dItem(item).getScriptName()) && (found_items += item.getAmount()) >= qty); ++i) {
            }
            return new Element(found_items >= qty).getAttribute(attribute.fulfill(attribs));
        }
        if (attribute.startsWith("contains.nbt") && attribute.hasContext(2)) {
            ItemStack item;
            String keyName = attribute.getContext(2);
            int qty = 1;
            int attribs = 2;
            if ((attribute.getAttribute(3).startsWith("quantity") || attribute.getAttribute(3).startsWith("qty")) && attribute.hasContext(3) && aH.matchesInteger(attribute.getContext(3))) {
                qty = attribute.getIntContext(3);
                attribs = 3;
            }
            int found_items = 0;
            ItemStack[] itemStackArray = this.getContents();
            int found_items2 = itemStackArray.length;
            for (int i = 0; !(i >= found_items2 || CustomNBT.hasCustomNBT(item = itemStackArray[i], keyName, "Denizen NBT") && (found_items += item.getAmount()) >= qty); ++i) {
            }
            return new Element(found_items >= qty).getAttribute(attribute.fulfill(attribs));
        }
        if (attribute.startsWith("contains.material") && attribute.hasContext(2) && dMaterial.matches(attribute.getContext(2))) {
            dMaterial material = dMaterial.valueOf(attribute.getContext(2));
            int qty = 1;
            int attribs = 2;
            if ((attribute.getAttribute(3).startsWith("quantity") || attribute.getAttribute(3).startsWith("qty")) && attribute.hasContext(3) && aH.matchesInteger(attribute.getContext(3))) {
                qty = attribute.getIntContext(3);
                attribs = 3;
            }
            int found_items = 0;
            for (ItemStack item : this.getContents()) {
                if (item != null && item.getType() == material.getMaterial() && (found_items += item.getAmount()) >= qty) break;
            }
            return new Element(found_items >= qty).getAttribute(attribute.fulfill(attribs));
        }
        if (attribute.startsWith("contains_any") && attribute.hasContext(1)) {
            List<dItem> contains;
            dList list = dList.valueOf(attribute.getContext(1));
            if (list.isEmpty()) {
                return null;
            }
            int qty = 1;
            int attribs = 1;
            if ((attribute.getAttribute(2).startsWith("quantity") || attribute.getAttribute(2).startsWith("qty")) && attribute.hasContext(2) && aH.matchesInteger(attribute.getContext(2))) {
                qty = attribute.getIntContext(2);
                attribs = 2;
            }
            if (!(contains = list.filter(dItem.class, attribute.getScriptEntry())).isEmpty()) {
                for (dItem item : contains) {
                    if (!this.containsItem(item, qty)) continue;
                    return new Element(true).getAttribute(attribute.fulfill(attribs));
                }
            }
            return new Element(false).getAttribute(attribute.fulfill(attribs));
        }
        if (attribute.startsWith("contains") && attribute.hasContext(1)) {
            List<dItem> contains;
            dList list = dList.valueOf(attribute.getContext(1));
            if (list.isEmpty()) {
                return null;
            }
            int qty = 1;
            int attribs = 1;
            if ((attribute.getAttribute(2).startsWith("quantity") || attribute.getAttribute(2).startsWith("qty")) && attribute.hasContext(2) && aH.matchesInteger(attribute.getContext(2))) {
                qty = attribute.getIntContext(2);
                attribs = 2;
            }
            if ((contains = list.filter(dItem.class, attribute.getScriptEntry())).size() == list.size()) {
                for (dItem item : contains) {
                    if (this.containsItem(item, qty)) continue;
                    return new Element(false).getAttribute(attribute.fulfill(attribs));
                }
                return new Element(true).getAttribute(attribute.fulfill(attribs));
            }
            return new Element(false).getAttribute(attribute.fulfill(attribs));
        }
        if (attribute.startsWith("first_empty")) {
            int val = this.firstEmpty(0);
            return new Element(val >= 0 ? val + 1 : -1).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("find.material") && attribute.hasContext(2) && dMaterial.matches(attribute.getContext(2))) {
            dMaterial material = dMaterial.valueOf(attribute.getContext(2));
            if (material == null) {
                return null;
            }
            int slot = -1;
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                if (this.inventory.getItem(i) == null || this.inventory.getItem(i).getType() != material.getMaterial()) continue;
                slot = i + 1;
                break;
            }
            return new Element(slot).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("find.scriptname") && attribute.hasContext(2) && dItem.matches(attribute.getContext(2))) {
            String scrname = dItem.valueOf(attribute.getContext(2), attribute.context).getScriptName();
            if (scrname == null) {
                return null;
            }
            int slot = -1;
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                if (this.inventory.getItem(i) == null || !scrname.equalsIgnoreCase(new dItem(this.inventory.getItem(i)).getScriptName())) continue;
                slot = i + 1;
                break;
            }
            return new Element(slot).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("find_imperfect") && attribute.hasContext(1) && dItem.matches(attribute.getContext(1))) {
            dItem item = dItem.valueOf(attribute.getContext(1), attribute.context);
            item.setAmount(1);
            int slot = -1;
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                if (this.inventory.getItem(i) == null) continue;
                dItem compare_to = new dItem(this.inventory.getItem(i).clone());
                compare_to.setAmount(1);
                if (!item.identify().equalsIgnoreCase(compare_to.identify()) && !item.getScriptName().equalsIgnoreCase(compare_to.getScriptName())) continue;
                slot = i + 1;
                break;
            }
            return new Element(slot).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("find") && attribute.hasContext(1) && dItem.matches(attribute.getContext(1))) {
            dItem item = dItem.valueOf(attribute.getContext(1), attribute.context);
            item.setAmount(1);
            int slot = -1;
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                if (this.inventory.getItem(i) == null) continue;
                dItem compare_to = new dItem(this.inventory.getItem(i).clone());
                compare_to.setAmount(1);
                if (!item.getFullString().equalsIgnoreCase(compare_to.getFullString())) continue;
                slot = i + 1;
                break;
            }
            return new Element(slot).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("id_type")) {
            return new Element(this.idType).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("notable_name")) {
            String notname = NotableManager.getSavedId(this);
            if (notname == null) {
                return null;
            }
            return new Element(notname).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location")) {
            dLocation location = this.getLocation();
            if (location == null) {
                return null;
            }
            return location.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("quantity.scriptname") && attribute.hasContext(2)) {
            return new Element(this.countByScriptName(attribute.getContext(2))).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("quantity.material") && attribute.hasContext(2) && dMaterial.matches(attribute.getContext(2))) {
            return new Element(this.countByMaterial(dMaterial.valueOf(attribute.getContext(2)).getMaterial())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("quantity") || attribute.startsWith("qty")) {
            if (attribute.hasContext(1) && dItem.matches(attribute.getContext(1))) {
                return new Element(this.count(dItem.valueOf(attribute.getContext(1), attribute.context).getItemStack(), false)).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.count(null, false)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("stacks")) {
            if (attribute.hasContext(1) && dItem.matches(attribute.getContext(1))) {
                return new Element(this.count(dItem.valueOf(attribute.getContext(1), attribute.context).getItemStack(), true)).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.count(null, true)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("slot") && attribute.hasContext(1) && aH.matchesInteger(attribute.getContext(1))) {
            int slot = new Element(attribute.getContext(1)).asInt() - 1;
            if (slot < 0) {
                slot = 0;
            } else if (slot > this.getInventory().getSize() - 1) {
                slot = this.getInventory().getSize() - 1;
            }
            return new dItem(this.getInventory().getItem(slot)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("inventory_type")) {
            return new Element(this.inventory instanceof HorseInventory ? "HORSE" : this.getInventory().getType().name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("equipment")) {
            dList equipment = this.getEquipment();
            if (equipment == null) {
                return null;
            }
            return equipment.getAttribute(attribute.fulfill(1));
        }
        if (this.inventory instanceof CraftingInventory) {
            CraftingInventory craftingInventory = (CraftingInventory)this.inventory;
            if (attribute.startsWith("matrix")) {
                dList recipeList = new dList();
                for (ItemStack item : craftingInventory.getMatrix()) {
                    if (item != null) {
                        recipeList.add(new dItem(item).identify());
                        continue;
                    }
                    recipeList.add(new dItem(Material.AIR).identify());
                }
                return recipeList.getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("result")) {
                ItemStack result = craftingInventory.getResult();
                if (result == null) {
                    return null;
                }
                return new dItem(result).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("type")) {
            return new Element("Inventory").getAttribute(attribute.fulfill(1));
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (NotableManager.isExactSavedObject(this)) {
            dB.echoError("Cannot apply properties to noted objects.");
            return;
        }
        if (this.idType == null) {
            this.mechanisms.add(mechanism);
        } else if (this.idType.equals("generic") || mechanism.matches("holder")) {
            this.adjust(mechanism);
        } else if (!this.idType.equals("location") || !mechanism.matches("title")) {
            dB.echoError("Cannot apply properties to non-generic inventory!");
        }
    }

    @Override
    public void adjust(Mechanism mechanism) {
        CraftingInventory craftingInventory;
        CoreUtilities.autoPropertyMechanism(this, mechanism);
        if (mechanism.matches("matrix") && mechanism.requireObject(dList.class)) {
            if (this.inventory instanceof CraftingInventory) {
                craftingInventory = (CraftingInventory)this.inventory;
                List<dItem> items = mechanism.valueAsType(dList.class).filter(dItem.class, mechanism.context);
                ItemStack[] itemStacks = new ItemStack[9];
                for (int i = 0; i < 9 && i < items.size(); ++i) {
                    itemStacks[i] = items.get(i).getItemStack();
                }
                craftingInventory.setMatrix(itemStacks);
                ((Player)this.inventory.getHolder()).updateInventory();
            } else {
                dB.echoError("Inventory is not a crafting inventory, cannot set matrix.");
            }
        }
        if (mechanism.matches("result") && mechanism.requireObject(dItem.class)) {
            if (this.inventory instanceof CraftingInventory) {
                craftingInventory = (CraftingInventory)this.inventory;
                craftingInventory.setResult(mechanism.valueAsType(dItem.class).getItemStack());
                ((Player)this.inventory.getHolder()).updateInventory();
            } else {
                dB.echoError("Inventory is not a crafting inventory, cannot set result.");
            }
        }
    }
}

