/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.HashMap;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class dPlugin
implements dObject {
    private Plugin plugin;
    private String prefix = "Plugin";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static dPlugin valueOf(String string) {
        return dPlugin.valueOf(string, null);
    }

    @Fetchable(value="pl")
    public static dPlugin valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = CoreUtilities.toLowerCase(string).replace("pl@", "");
        try {
            for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                if (!string.equalsIgnoreCase(plugin.getName())) continue;
                return new dPlugin(plugin);
            }
        }
        catch (Exception e) {
            net.aufdemrand.denizen.utilities.debugging.dB.echoError("Invalid plugin name specified, or plugin is not enabled: " + string);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (CoreUtilities.toLowerCase(arg).startsWith("pl@")) {
            return true;
        }
        for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
            if (!arg.equalsIgnoreCase(plugin.getName())) continue;
            return true;
        }
        return false;
    }

    public dPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getObjectType() {
        return "Plugin";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String identify() {
        return "pl@" + this.plugin.getName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public dPlugin setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static void registerTags() {
        dPlugin.registerTag("name", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dPlugin)object).plugin.getName()).getAttribute(attribute.fulfill(1));
            }
        });
        dPlugin.registerTag("version", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dPlugin)object).plugin.getDescription().getVersion()).getAttribute(attribute.fulfill(1));
            }
        });
        dPlugin.registerTag("description", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dPlugin)object).plugin.getDescription().getDescription()).getAttribute(attribute.fulfill(1));
            }
        });
        dPlugin.registerTag("authors", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new dList(((dPlugin)object).plugin.getDescription().getAuthors()).getAttribute(attribute.fulfill(1));
            }
        });
        dPlugin.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element("Plugin").getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }
}

