/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.Age;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Zombie;

public class EntityAge
implements Property {
    public static final String[] handledTags = new String[]{"age", "is_age_locked", "is_baby"};
    public static final String[] handledMechs = new String[]{"age_lock", "age"};
    dEntity ageable;

    public static boolean describes(dObject entity) {
        if (!(entity instanceof dEntity)) {
            return false;
        }
        return ((dEntity)entity).getBukkitEntity() instanceof Ageable || ((dEntity)entity).getBukkitEntity() instanceof Zombie;
    }

    public static EntityAge getFrom(dObject entity) {
        if (!EntityAge.describes(entity)) {
            return null;
        }
        return new EntityAge((dEntity)entity);
    }

    private EntityAge(dEntity entity) {
        this.ageable = entity;
    }

    public boolean isBaby() {
        if (this.ageable.getBukkitEntity() instanceof Zombie) {
            return ((Zombie)this.ageable.getBukkitEntity()).isBaby();
        }
        return !((Ageable)this.ageable.getBukkitEntity()).isAdult();
    }

    public void setBaby(boolean bool) {
        if (this.ageable.isCitizensNPC()) {
            NPC ageable_npc = this.ageable.getDenizenNPC().getCitizen();
            if (!ageable_npc.hasTrait(Age.class)) {
                ageable_npc.addTrait(Age.class);
            }
            ((Age)ageable_npc.getTrait(Age.class)).setAge(bool ? -24000 : 0);
        } else if (this.ageable.getBukkitEntity() instanceof Zombie) {
            ((Zombie)this.ageable.getBukkitEntity()).setBaby(bool);
        } else if (bool) {
            ((Ageable)this.ageable.getBukkitEntity()).setBaby();
        } else {
            ((Ageable)this.ageable.getBukkitEntity()).setAdult();
        }
    }

    public void setAge(int val) {
        if (this.ageable.isCitizensNPC()) {
            NPC ageable_npc = this.ageable.getDenizenNPC().getCitizen();
            ((Age)ageable_npc.getTrait(Age.class)).setAge(val);
        } else if (this.ageable.getBukkitEntity() instanceof Zombie) {
            ((Zombie)this.ageable.getBukkitEntity()).setBaby(val >= 0);
        } else {
            ((Ageable)this.ageable.getBukkitEntity()).setAge(val);
        }
    }

    public int getAge() {
        if (this.ageable.getBukkitEntity() instanceof Zombie) {
            return ((Zombie)this.ageable.getBukkitEntity()).isBaby() ? -24000 : 0;
        }
        return ((Ageable)this.ageable.getBukkitEntity()).getAge();
    }

    public void setLock(boolean bool) {
        if (!(this.ageable.getBukkitEntity() instanceof Zombie)) {
            ((Ageable)this.ageable.getBukkitEntity()).setAgeLock(bool);
        }
    }

    public boolean getLock() {
        return this.ageable.getBukkitEntity() instanceof Zombie || ((Ageable)this.ageable.getBukkitEntity()).getAgeLock();
    }

    @Override
    public String getPropertyString() {
        return this.getAge() + (this.getLock() ? "|locked" : "");
    }

    @Override
    public String getPropertyId() {
        return "age";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("age")) {
            return new Element(this.getAge()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_age_locked")) {
            return new Element(this.getLock()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_baby")) {
            return new Element(this.isBaby()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("age_lock") && mechanism.requireBoolean()) {
            this.setLock(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("age")) {
            dList list = mechanism.valueAsType(dList.class);
            if (list.size() == 0) {
                dB.echoError("Missing value for 'age' mechanism!");
                return;
            }
            if (((String)list.get(0)).equalsIgnoreCase("baby")) {
                this.setBaby(true);
            } else if (((String)list.get(0)).equalsIgnoreCase("adult")) {
                this.setBaby(false);
            } else if (new Element((String)list.get(0)).isInt()) {
                this.setAge(new Element((String)list.get(0)).asInt());
            }
            if (list.size() > 1 && ((String)list.get(1)).equalsIgnoreCase("locked")) {
                this.setLock(true);
            } else if (list.size() > 1 && ((String)list.get(1)).equalsIgnoreCase("unlocked")) {
                this.setLock(false);
            }
        }
    }
}

