/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.ArrayList;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.MaterialCompat;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Material;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBook
implements Property {
    public static final String[] handledTags = new String[]{"book"};
    public static final String[] handledMechs = new String[]{"book", "book_raw_pages", "book_pages", "book_author", "book_title"};
    dItem item;

    public static boolean describes(dObject item) {
        Material material = ((dItem)item).getItemStack().getType();
        return material == Material.WRITTEN_BOOK || material == MaterialCompat.WRITABLE_BOOK;
    }

    public static ItemBook getFrom(dObject _item) {
        if (!ItemBook.describes(_item)) {
            return null;
        }
        return new ItemBook((dItem)_item);
    }

    private ItemBook(dItem _item) {
        this.item = _item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("book")) {
            BookMeta bookInfo = (BookMeta)this.item.getItemStack().getItemMeta();
            attribute = attribute.fulfill(1);
            if (this.item.getItemStack().getType() == Material.WRITTEN_BOOK) {
                if (attribute.startsWith("author")) {
                    return new Element(bookInfo.getAuthor()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("title")) {
                    return new Element(bookInfo.getTitle()).getAttribute(attribute.fulfill(1));
                }
            }
            if (attribute.startsWith("page_count")) {
                return new Element(bookInfo.getPageCount()).getAttribute(attribute.fulfill(1));
            }
            if ((attribute.startsWith("page") || attribute.startsWith("get_page")) && attribute.hasContext(1) && aH.matchesInteger(attribute.getContext(1))) {
                return new Element(bookInfo.getPage(attribute.getIntContext(1))).getAttribute(attribute.fulfill(1));
            }
            if ((attribute.startsWith("raw_page") || attribute.startsWith("get_raw_page")) && attribute.hasContext(1) && aH.matchesInteger(attribute.getContext(1))) {
                return new Element(ComponentSerializer.toString((BaseComponent[])bookInfo.spigot().getPage(attribute.getIntContext(1)))).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("pages.escaped")) {
                StringBuilder output = new StringBuilder();
                for (String page : bookInfo.getPages()) {
                    output.append(EscapeTags.escape(page)).append("|");
                }
                return new dList(output.length() > 0 ? output.substring(0, output.length() - 1) : output.toString()).getAttribute(attribute.fulfill(2));
            }
            if (attribute.startsWith("pages")) {
                return new dList(bookInfo.getPages()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("raw_pages")) {
                dList output = new dList();
                for (BaseComponent[] page : bookInfo.spigot().getPages()) {
                    output.add(ComponentSerializer.toString((BaseComponent[])page));
                }
                return output.getAttribute(attribute.fulfill(1));
            }
            String output = this.getOutputString();
            if (output == null) {
                output = "null";
            }
            return new Element(output).getAttribute(attribute);
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        String output = this.getOutputString();
        if (output.equals("raw_pages")) {
            return null;
        }
        return output;
    }

    public String getOutputString() {
        StringBuilder output = new StringBuilder();
        BookMeta bookInfo = (BookMeta)this.item.getItemStack().getItemMeta();
        if (this.item.getItemStack().getType().equals((Object)Material.WRITTEN_BOOK) && bookInfo.hasAuthor() && bookInfo.hasTitle()) {
            output.append("author|").append(EscapeTags.escape(bookInfo.getAuthor())).append("|title|").append(EscapeTags.escape(bookInfo.getTitle())).append("|");
        }
        output.append("raw_pages|");
        if (bookInfo.hasPages()) {
            for (BaseComponent[] page : bookInfo.spigot().getPages()) {
                output.append(EscapeTags.escape(ComponentSerializer.toString((BaseComponent[])page))).append("|");
            }
        }
        return output.substring(0, output.length() - 1);
    }

    @Override
    public String getPropertyId() {
        return "book";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        ArrayList<Object> newPages;
        dList data;
        BookMeta meta;
        if (mechanism.matches("book_raw_pages")) {
            meta = (BookMeta)this.item.getItemStack().getItemMeta();
            data = mechanism.valueAsType(dList.class);
            newPages = new ArrayList<Object>();
            for (String str : data) {
                newPages.add(ComponentSerializer.parse((String)EscapeTags.unEscape(str)));
            }
            meta.spigot().setPages(newPages);
            this.item.getItemStack().setItemMeta((ItemMeta)meta);
        }
        if (mechanism.matches("book_pages")) {
            meta = (BookMeta)this.item.getItemStack().getItemMeta();
            data = mechanism.valueAsType(dList.class);
            newPages = new ArrayList();
            for (String str : data) {
                newPages.add(EscapeTags.unEscape(str));
            }
            meta.setPages(newPages);
            this.item.getItemStack().setItemMeta((ItemMeta)meta);
        }
        if (mechanism.matches("book_author")) {
            if (!this.item.getItemStack().getType().equals((Object)Material.WRITTEN_BOOK)) {
                dB.echoError("Only WRITTEN_BOOK (not WRITABLE_BOOK) can have a title or author!");
            } else {
                meta = (BookMeta)this.item.getItemStack().getItemMeta();
                meta.setAuthor(mechanism.getValue().asString());
                this.item.getItemStack().setItemMeta((ItemMeta)meta);
            }
        }
        if (mechanism.matches("book_title")) {
            if (!this.item.getItemStack().getType().equals((Object)Material.WRITTEN_BOOK)) {
                dB.echoError("Only WRITTEN_BOOK (not WRITABLE_BOOK) can have a title or author!");
            } else {
                meta = (BookMeta)this.item.getItemStack().getItemMeta();
                meta.setTitle(mechanism.getValue().asString());
                this.item.getItemStack().setItemMeta((ItemMeta)meta);
            }
        }
        if (mechanism.matches("book")) {
            meta = (BookMeta)this.item.getItemStack().getItemMeta();
            data = mechanism.valueAsType(dList.class);
            if (data.size() < 2) {
                dB.echoError("Invalid book input!");
            } else {
                if (data.size() > 4 && ((String)data.get(0)).equalsIgnoreCase("author") && ((String)data.get(2)).equalsIgnoreCase("title")) {
                    if (!this.item.getItemStack().getType().equals((Object)Material.WRITTEN_BOOK)) {
                        dB.echoError("Only WRITTEN_BOOK (not WRITABLE_BOOK) can have a title or author!");
                    } else {
                        meta.setAuthor(EscapeTags.unEscape((String)data.get(1)));
                        meta.setTitle(EscapeTags.unEscape((String)data.get(3)));
                        for (int i = 0; i < 4; ++i) {
                            data.remove(0);
                        }
                    }
                }
                if (((String)data.get(0)).equalsIgnoreCase("raw_pages")) {
                    ArrayList<BaseComponent[]> newPages2 = new ArrayList<BaseComponent[]>();
                    for (int i = 1; i < data.size(); ++i) {
                        newPages2.add(ComponentSerializer.parse((String)EscapeTags.unEscape((String)data.get(i))));
                    }
                    meta.spigot().setPages(newPages2);
                } else if (((String)data.get(0)).equalsIgnoreCase("pages")) {
                    ArrayList<String> newPages3 = new ArrayList<String>();
                    for (int i = 1; i < data.size(); ++i) {
                        newPages3.add(EscapeTags.unEscape((String)data.get(i)));
                    }
                    meta.setPages(newPages3);
                } else {
                    dB.echoError("Invalid book input!");
                }
                this.item.getItemStack().setItemMeta((ItemMeta)meta);
            }
        }
    }
}

