/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.List;
import java.util.stream.Collectors;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemCanPlaceOn
implements Property {
    public static final String[] handledTags = new String[]{"can_place_on"};
    public static final String[] handledMechs = new String[]{"can_place_on"};
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem;
    }

    public static ItemCanPlaceOn getFrom(dObject item) {
        if (!ItemCanPlaceOn.describes(item)) {
            return null;
        }
        return new ItemCanPlaceOn((dItem)item);
    }

    private ItemCanPlaceOn(dItem item) {
        this.item = item;
    }

    private dList getMaterials() {
        ItemStack itemStack = this.item.getItemStack();
        List<Material> materials = CustomNBT.getNBTMaterials(itemStack, "CanPlaceOn");
        if (materials != null && !materials.isEmpty()) {
            dList list = new dList();
            for (Material material : materials) {
                list.addObject(new dMaterial(material));
            }
            return list;
        }
        return null;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        dList materials;
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("can_place_on") && (materials = this.getMaterials()) != null) {
            return materials.getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        dList materials = this.getMaterials();
        return materials != null ? materials.identify() : null;
    }

    @Override
    public String getPropertyId() {
        return "can_place_on";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("can_place_on")) {
            if (this.item.getMaterial().getMaterial() == Material.AIR) {
                dB.echoError("Cannot apply NBT to AIR!");
                return;
            }
            ItemStack itemStack = this.item.getItemStack();
            if (mechanism.hasValue()) {
                List<Material> materials = mechanism.valueAsType(dList.class).filter(dMaterial.class, mechanism.context).stream().map(dMaterial::getMaterial).collect(Collectors.toList());
                itemStack = CustomNBT.setNBTMaterials(itemStack, "CanPlaceOn", materials);
            } else {
                itemStack = CustomNBT.clearNBT(itemStack, "CanPlaceOn");
            }
            this.item.setItemStack(itemStack);
        }
    }
}

