/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemUnbreakable
implements Property {
    public static final String[] handledTags = new String[]{"unbreakable"};
    public static final String[] handledMechs = new String[]{"unbreakable"};
    dItem item;

    public static boolean describes(dObject object) {
        return object instanceof dItem;
    }

    public static ItemUnbreakable getFrom(dObject object) {
        if (!ItemUnbreakable.describes(object)) {
            return null;
        }
        return new ItemUnbreakable((dItem)object);
    }

    private ItemUnbreakable(dItem item) {
        this.item = item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("unbreakable")) {
            return new Element(this.getPropertyString() != null).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        ItemStack itemStack = this.item.getItemStack();
        return itemStack.hasItemMeta() && itemStack.getItemMeta().isUnbreakable() ? "true" : null;
    }

    @Override
    public String getPropertyId() {
        return "unbreakable";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("unbreakable") && mechanism.requireBoolean()) {
            ItemStack itemStack = this.item.getItemStack().clone();
            ItemMeta meta = itemStack.getItemMeta();
            meta.setUnbreakable(mechanism.getValue().asBoolean());
            itemStack.setItemMeta(meta);
            this.item.setItemStack(itemStack);
        }
    }
}

