/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.material;

import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.block.data.Ageable;

public class MaterialAge
implements Property {
    public static final String[] handledTags = new String[]{"maximum_age", "age", "maximum_plant_growth", "plant_growth"};
    public static final String[] handledMechs = new String[]{"age", "plant_growth"};
    dMaterial material;

    public static boolean describes(dObject material) {
        return material instanceof dMaterial && ((dMaterial)material).hasModernData() && ((dMaterial)material).getModernData().data instanceof Ageable;
    }

    public static MaterialAge getFrom(dObject _material) {
        if (!MaterialAge.describes(_material)) {
            return null;
        }
        return new MaterialAge((dMaterial)_material);
    }

    private MaterialAge(dMaterial _material) {
        this.material = _material;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("maximum_age") || attribute.startsWith("maximum_plant_growth")) {
            return new Element(this.getMax()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("age") || attribute.startsWith("plant_growth")) {
            return new Element(this.getCurrent()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public Ageable getAgeable() {
        return (Ageable)this.material.getModernData().data;
    }

    public int getCurrent() {
        return this.getAgeable().getAge();
    }

    public int getMax() {
        return this.getAgeable().getMaximumAge();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "age";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("age") || mechanism.matches("plant_growth")) && mechanism.requireInteger()) {
            int age = mechanism.getValue().asInt();
            if (age < 0 || age > this.getMax()) {
                dB.echoError("Age value '" + age + "' is not valid. Must be between 0 and " + this.getMax() + " for material '" + this.material.realName() + "'.");
                return;
            }
            this.getAgeable().setAge(age);
        }
    }
}

