/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.properties.entity.EntityAge;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class AgeCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("agetype") && arg.matchesEnum(AgeType.values())) {
                scriptEntry.addObject("agetype", (Object)AgeType.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("age") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("age", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("lock") && arg.matches("lock")) {
                scriptEntry.addObject("lock", new Element(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("No valid entities specified.");
        }
        scriptEntry.defaultObject("age", new Element(1));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List entities = (List)scriptEntry.getObject("entities");
        AgeType ageType = (AgeType)((Object)scriptEntry.getObject("agetype"));
        int age = scriptEntry.getElement("age").asInt();
        boolean lock = scriptEntry.hasObject("lock");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), (lock ? aH.debugObj("lock", lock) : "") + (ageType != null ? aH.debugObj("agetype", (Object)ageType) : aH.debugObj("age", age)) + aH.debugObj("entities", entities.toString()));
        }
        for (dEntity entity : entities) {
            if (!entity.isSpawned()) continue;
            if (EntityAge.describes(entity)) {
                EntityAge property = EntityAge.getFrom(entity);
                if (ageType != null) {
                    if (ageType.equals((Object)AgeType.BABY)) {
                        property.setBaby(true);
                    } else {
                        property.setBaby(false);
                    }
                } else {
                    property.setAge(age);
                }
                property.setLock(lock);
                continue;
            }
            dB.echoError(scriptEntry.getResidingQueue(), entity.identify() + " is not ageable!");
        }
    }

    private static enum AgeType {
        ADULT,
        BABY;

    }
}

