/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class BurnCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("entities", Utilities.entryHasPlayer(scriptEntry) ? Arrays.asList(Utilities.getEntryPlayer(scriptEntry).getDenizenEntity()) : null, Utilities.entryHasNPC(scriptEntry) ? Arrays.asList(Utilities.getEntryNPC(scriptEntry).getDenizenEntity()) : null);
        scriptEntry.defaultObject("duration", Duration.valueOf("5s"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List entities = (List)scriptEntry.getObject("entities");
        Duration duration = (Duration)scriptEntry.getObject("duration");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), duration.debug() + aH.debugObj("entities", entities.toString()));
        }
        for (dEntity entity : entities) {
            if (!entity.isSpawned()) continue;
            entity.getBukkitEntity().setFireTicks(duration.getTicksAsInt());
        }
    }
}

