/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RotateCommand
extends AbstractCommand
implements Holdable {
    public static Set<UUID> rotatingEntities = new HashSet<UUID>();

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("cancel") && (arg.matches("cancel") || arg.matches("stop"))) {
                scriptEntry.addObject("cancel", new Element("true"));
                continue;
            }
            if (!scriptEntry.hasObject("infinite") && arg.matches("infinite")) {
                scriptEntry.addObject("infinite", new Element("true"));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class) && arg.matchesPrefix("duration", "d")) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("frequency") && arg.matchesArgumentType(Duration.class) && arg.matchesPrefix("frequency", "f")) {
                scriptEntry.addObject("frequency", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("yaw") && arg.matchesPrefix("yaw", "y", "rotation", "r") && arg.matchesPrimitive(aH.PrimitiveType.Float)) {
                scriptEntry.addObject("yaw", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("pitch") && arg.matchesPrefix("pitch", "p", "tilt", "t") && arg.matchesPrimitive(aH.PrimitiveType.Float)) {
                scriptEntry.addObject("pitch", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("entities", Utilities.entryHasPlayer(scriptEntry) ? Arrays.asList(Utilities.getEntryPlayer(scriptEntry).getDenizenEntity()) : null, Utilities.entryHasNPC(scriptEntry) ? Arrays.asList(Utilities.getEntryNPC(scriptEntry).getDenizenEntity()) : null);
        scriptEntry.defaultObject("yaw", new Element(10));
        scriptEntry.defaultObject("pitch", new Element(0));
        scriptEntry.defaultObject("duration", new Duration(20));
        scriptEntry.defaultObject("frequency", Duration.valueOf("1t"));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        final ArrayList entities = new ArrayList((List)scriptEntry.getObject("entities"));
        final Duration duration = (Duration)scriptEntry.getObject("duration");
        final Duration frequency = (Duration)scriptEntry.getObject("frequency");
        final Element yaw = (Element)scriptEntry.getObject("yaw");
        final Element pitch = (Element)scriptEntry.getObject("pitch");
        boolean cancel = scriptEntry.hasObject("cancel");
        final boolean infinite = scriptEntry.hasObject("infinite");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), (cancel ? aH.debugObj("cancel", cancel) : "") + aH.debugObj("entities", ((Object)entities).toString()) + (infinite ? aH.debugObj("duration", "infinite") : duration.debug()) + frequency.debug() + yaw.debug() + pitch.debug());
        }
        for (dEntity entity : entities) {
            if (cancel) {
                rotatingEntities.remove(entity.getUUID());
                continue;
            }
            rotatingEntities.add(entity.getUUID());
        }
        if (cancel) {
            return;
        }
        BukkitRunnable task = new BukkitRunnable(){
            int ticks = 0;
            int maxTicks = duration.getTicksAsInt();
            Collection<dEntity> unusedEntities = new LinkedList<dEntity>();

            public void run() {
                if (entities.isEmpty()) {
                    scriptEntry.setFinished(true);
                    this.cancel();
                } else if (infinite || this.ticks < this.maxTicks) {
                    for (dEntity entity : entities) {
                        if (entity.isSpawned() && rotatingEntities.contains(entity.getUUID())) {
                            NMSHandler.getInstance().getEntityHelper().rotate(entity.getBukkitEntity(), NMSHandler.getInstance().getEntityHelper().normalizeYaw(entity.getLocation().getYaw() + yaw.asFloat()), entity.getLocation().getPitch() + pitch.asFloat());
                            continue;
                        }
                        rotatingEntities.remove(entity.getUUID());
                        this.unusedEntities.add(entity);
                    }
                    if (!this.unusedEntities.isEmpty()) {
                        for (dEntity unusedEntity : this.unusedEntities) {
                            entities.remove(unusedEntity);
                        }
                        this.unusedEntities.clear();
                    }
                    this.ticks = (int)((long)this.ticks + frequency.getTicks());
                } else {
                    scriptEntry.setFinished(true);
                    this.cancel();
                }
            }
        };
        task.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 0L, frequency.getTicks());
    }
}

