/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.scripts.commands.entity.WalkCommand;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.event.NavigationEvent;
import net.citizensnpcs.api.ai.flocking.AlignmentBehavior;
import net.citizensnpcs.api.ai.flocking.CohesionBehavior;
import net.citizensnpcs.api.ai.flocking.FlockBehavior;
import net.citizensnpcs.api.ai.flocking.Flocker;
import net.citizensnpcs.api.ai.flocking.NPCFlock;
import net.citizensnpcs.api.ai.flocking.RadiusNPCFlock;
import net.citizensnpcs.api.ai.flocking.SeparationBehavior;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class WalkCommandCitizensEvents
implements Listener {
    public static double HIGH_INFLUENCE = 0.05;
    public static double LOW_INFLUENCE = 0.005;

    public static Flocker generateNewFlocker(NPC npc, double radius) {
        RadiusNPCFlock flock = new RadiusNPCFlock(radius);
        return new Flocker(npc, (NPCFlock)flock, new FlockBehavior[]{new SeparationBehavior(LOW_INFLUENCE), new CohesionBehavior(LOW_INFLUENCE), new AlignmentBehavior(HIGH_INFLUENCE)});
    }

    @EventHandler
    public void finish(NavigationCompleteEvent e) {
        if (WalkCommand.held.isEmpty()) {
            return;
        }
        this.checkHeld((NavigationEvent)e);
    }

    @EventHandler
    public void cancel(NavigationCancelEvent e) {
        if (WalkCommand.held.isEmpty()) {
            return;
        }
        this.checkHeld((NavigationEvent)e);
    }

    public void checkHeld(NavigationEvent e) {
        if (e.getNPC() == null) {
            return;
        }
        for (int i = 0; i < WalkCommand.held.size(); ++i) {
            ScriptEntry entry = WalkCommand.held.get(i);
            List tally = (List)entry.getObject("tally");
            if (tally == null) continue;
            for (int x = 0; x < tally.size(); ++x) {
                if (((dNPC)tally.get(x)).isSpawned()) continue;
                tally.remove(x--);
            }
            tally.remove(dNPC.mirrorCitizensNPC(e.getNPC()));
            if (!tally.isEmpty()) continue;
            entry.setFinished(true);
            WalkCommand.held.remove(i);
            --i;
        }
    }
}

