/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import java.util.List;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.inventory.SlotHelper;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("qty") && arg.matchesPrefix("q", "qty", "quantity") && arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                scriptEntry.addObject("qty", arg.asElement());
                scriptEntry.addObject("set_quantity", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("money", "coins")) {
                scriptEntry.addObject("type", (Object)Type.MONEY);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("xp", "exp", "experience")) {
                scriptEntry.addObject("type", (Object)Type.EXP);
                continue;
            }
            if (!scriptEntry.hasObject("engrave") && arg.matches("engrave")) {
                scriptEntry.addObject("engrave", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("unlimit_stack_size") && arg.matches("unlimit_stack_size")) {
                scriptEntry.addObject("unlimit_stack_size", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("items") && !scriptEntry.hasObject("type") && (arg.matchesArgumentList(dItem.class) || arg.startsWith("item:"))) {
                scriptEntry.addObject("items", dList.valueOf(arg.raw_value.startsWith("item:") ? arg.raw_value.substring("item:".length()) : arg.raw_value).filter(dItem.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("inventory") && arg.matchesPrefix("t", "to") && arg.matchesArgumentType(dInventory.class)) {
                scriptEntry.addObject("inventory", arg.asType(dInventory.class));
                continue;
            }
            if (!scriptEntry.hasObject("slot") && arg.matchesPrefix("slot")) {
                scriptEntry.addObject("slot", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("type", new Object[]{Type.ITEM}).defaultObject("engrave", new Element(false)).defaultObject("unlimit_stack_size", new Element(false)).defaultObject("qty", new Element(1)).defaultObject("slot", new Element(1));
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        if (type != Type.MONEY && scriptEntry.getObject("inventory") == null) {
            scriptEntry.addObject("inventory", Utilities.entryHasPlayer(scriptEntry) ? Utilities.getEntryPlayer(scriptEntry).getInventory() : null);
        }
        if (!scriptEntry.hasObject("inventory") && type != Type.MONEY) {
            throw new InvalidArgumentsException("Must specify an inventory to give to!");
        }
        if (type == Type.ITEM && scriptEntry.getObject("items") == null) {
            throw new InvalidArgumentsException("Must specify item/items!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Element engrave = scriptEntry.getElement("engrave");
        Element unlimit_stack_size = scriptEntry.getElement("unlimit_stack_size");
        dInventory inventory = (dInventory)scriptEntry.getObject("inventory");
        Element qty = scriptEntry.getElement("qty");
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        Element slot = scriptEntry.getElement("slot");
        Object items_object = scriptEntry.getObject("items");
        List items = null;
        if (items_object != null) {
            items = (List)items_object;
        }
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugObj("Type", type.name()) + (inventory != null ? inventory.debug() : "") + aH.debugObj("Quantity", qty.asDouble()) + engrave.debug() + unlimit_stack_size.debug() + (items != null ? aH.debugObj("Items", items) : "") + slot.debug());
        }
        switch (type) {
            case MONEY: {
                if (Depends.economy != null) {
                    Depends.economy.depositPlayer(Utilities.getEntryPlayer(scriptEntry).getOfflinePlayer(), qty.asDouble());
                    break;
                }
                dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                break;
            }
            case EXP: {
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().giveExp(qty.asInt());
                break;
            }
            case ITEM: {
                boolean set_quantity = scriptEntry.hasObject("set_quantity");
                boolean limited = !unlimit_stack_size.asBoolean();
                for (dItem item : items) {
                    int slotId;
                    ItemStack is = item.getItemStack();
                    if (is.getType() == Material.AIR) {
                        dB.echoError("Cannot give air!");
                        continue;
                    }
                    if (set_quantity) {
                        is.setAmount(qty.asInt());
                    }
                    if (engrave.asBoolean()) {
                        is = CustomNBT.addCustomNBT(item.getItemStack(), "owner", Utilities.getEntryPlayer(scriptEntry).getName(), "Denizen NBT");
                    }
                    if ((slotId = SlotHelper.nameToIndex(slot.asString())) == -1) {
                        dB.echoError(scriptEntry.getResidingQueue(), "The input '" + slot.asString() + "' is not a valid slot!");
                        return;
                    }
                    List<ItemStack> leftovers = inventory.addWithLeftovers(slotId, limited, is);
                    if (leftovers.isEmpty()) continue;
                    dB.echoDebug((Debuggable)scriptEntry, "The inventory didn't have enough space, the rest of the items have been placed on the floor.");
                    for (ItemStack leftoverItem : leftovers) {
                        inventory.getLocation().getWorld().dropItem((Location)inventory.getLocation(), leftoverItem);
                    }
                }
                break;
            }
        }
    }

    static enum Type {
        ITEM,
        MONEY,
        EXP;

    }
}

