/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import java.util.AbstractMap;
import java.util.List;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.inventory.SlotHelper;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class InventoryCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean isAdjust = false;
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("actions") && arg.matchesEnumList(Action.values())) {
                scriptEntry.addObject("actions", arg.asType(dList.class).filter(Action.values()));
                isAdjust = arg.toString().equalsIgnoreCase("adjust");
                continue;
            }
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin", "o", "source", "items", "item", "i", "from", "f") && (arg.matchesArgumentTypes(dInventory.class, dEntity.class, dLocation.class) || arg.matchesArgumentList(dItem.class))) {
                scriptEntry.addObject("origin", Conversion.getInventory(arg, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesPrefix("destination", "dest", "d", "target", "to", "t") && arg.matchesArgumentTypes(dInventory.class, dEntity.class, dLocation.class)) {
                scriptEntry.addObject("destination", Conversion.getInventory(arg, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("slot") && arg.matchesPrefix("slot, s")) {
                scriptEntry.addObject("slot", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("mechanism") && isAdjust) {
                if (arg.hasPrefix()) {
                    scriptEntry.addObject("mechanism", new Element(arg.getPrefix().getValue()));
                    scriptEntry.addObject("mechanism_value", arg.asElement());
                    continue;
                }
                scriptEntry.addObject("mechanism", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("actions")) {
            throw new InvalidArgumentsException("Must specify an Inventory action!");
        }
        if (isAdjust && !scriptEntry.hasObject("mechanism")) {
            throw new InvalidArgumentsException("Inventory adjust must have a mechanism!");
        }
        if (isAdjust && !scriptEntry.hasObject("slot")) {
            throw new InvalidArgumentsException("Inventory adjust must have an explicit slot!");
        }
        scriptEntry.defaultObject("slot", new Element(1));
        scriptEntry.defaultObject("destination", Utilities.entryHasPlayer(scriptEntry) ? new AbstractMap.SimpleEntry<Integer, dInventory>(0, Utilities.getEntryPlayer(scriptEntry).getDenizenEntity().getInventory()) : null);
        if (!scriptEntry.hasObject("destination")) {
            throw new InvalidArgumentsException("Must specify a Destination Inventory!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        int slotId;
        List actions = (List)scriptEntry.getObject("actions");
        AbstractMap.SimpleEntry originentry = (AbstractMap.SimpleEntry)scriptEntry.getObject("origin");
        dInventory origin = originentry != null ? (dInventory)originentry.getValue() : null;
        AbstractMap.SimpleEntry destinationentry = (AbstractMap.SimpleEntry)scriptEntry.getObject("destination");
        dInventory destination = (dInventory)destinationentry.getValue();
        Element slot = scriptEntry.getElement("slot");
        Element mechanism = scriptEntry.getElement("mechanism");
        Element mechanismValue = scriptEntry.getElement("mechanism_value");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugObj("actions", actions.toString()) + destination.debug() + (origin != null ? origin.debug() : "") + (mechanism != null ? mechanism.debug() : "") + (mechanismValue != null ? mechanismValue.debug() : "") + slot.debug());
        }
        if ((slotId = SlotHelper.nameToIndex(slot.asString())) == -1) {
            dB.echoError(scriptEntry.getResidingQueue(), "The input '" + slot.asString() + "' is not a valid slot!");
            return;
        }
        for (String action : actions) {
            switch (Action.valueOf(action.toUpperCase())) {
                case OPEN: {
                    if (destination.getIdType().equals("workbench") || destination.getIdHolder().equalsIgnoreCase("workbench")) {
                        Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().openWorkbench(null, true);
                        break;
                    }
                    Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().openInventory(destination.getInventory());
                    break;
                }
                case CLOSE: {
                    Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().closeInventory();
                    break;
                }
                case COPY: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    origin.replace(destination);
                    break;
                }
                case MOVE: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    origin.replace(destination);
                    origin.clear();
                    break;
                }
                case SWAP: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    dInventory temp = new dInventory(destination.getInventory());
                    origin.replace(destination);
                    temp.replace(origin);
                    break;
                }
                case ADD: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.add(slotId, origin.getContents());
                    break;
                }
                case REMOVE: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.remove(origin.getContents());
                    break;
                }
                case SET: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.setSlots(slotId, origin.getContents(), (Integer)originentry.getKey());
                    break;
                }
                case KEEP: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.keep(origin.getContents());
                    break;
                }
                case EXCLUDE: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.exclude(origin.getContents());
                    break;
                }
                case FILL: {
                    if (origin == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.fill(origin.getContents());
                    break;
                }
                case CLEAR: {
                    destination.clear();
                    break;
                }
                case UPDATE: {
                    if (destination.update()) break;
                    dB.echoError("Only player inventories can be force-updated!");
                    break;
                }
                case ADJUST: {
                    dItem toAdjust = new dItem(destination.getInventory().getItem(slotId));
                    toAdjust.safeAdjust(new Mechanism(mechanism, mechanismValue, scriptEntry.entryData.getTagContext()));
                    destination.getInventory().setItem(slotId, toAdjust.getItemStack());
                }
            }
        }
    }

    private static enum Action {
        OPEN,
        CLOSE,
        COPY,
        MOVE,
        SWAP,
        ADD,
        REMOVE,
        SET,
        KEEP,
        EXCLUDE,
        FILL,
        CLEAR,
        UPDATE,
        ADJUST;

    }
}

