/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class AssignmentCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (arg.matchesEnum(Action.values()) && !scriptEntry.hasObject("action")) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (arg.matchesArgumentType(dScript.class) && !scriptEntry.hasObject("script")) {
                if (arg.asType(dScript.class) != null && arg.asType(dScript.class).getType().equalsIgnoreCase("assignment")) {
                    scriptEntry.addObject("script", arg.asType(dScript.class));
                    continue;
                }
                throw new InvalidArgumentsException("Script specified is not an 'assignment-type' container.");
            }
            arg.reportUnhandled();
        }
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("NPC linked was missing or invalid.");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
        if (scriptEntry.getObject("action").equals((Object)Action.SET) && !scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Script specified was missing or invalid.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        dScript script = (dScript)scriptEntry.getdObject("script");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugObj("action", scriptEntry.getObject("action")) + (script != null ? script.debug() : ""));
        }
        if (scriptEntry.getObject("action").equals((Object)Action.SET)) {
            ((AssignmentTrait)Utilities.getEntryNPC(scriptEntry).getCitizen().getTrait(AssignmentTrait.class)).setAssignment(script.getName(), Utilities.getEntryPlayer(scriptEntry));
        } else if (scriptEntry.getObject("action").equals((Object)Action.REMOVE)) {
            ((AssignmentTrait)Utilities.getEntryNPC(scriptEntry).getCitizen().getTrait(AssignmentTrait.class)).removeAssignment(Utilities.getEntryPlayer(scriptEntry));
        }
    }

    private static enum Action {
        SET,
        REMOVE;

    }
}

