/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.trait.LookClose;

public class LookcloseCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (arg.matches("realistic", "realistically")) {
                scriptEntry.addObject("realistic", new Element(true));
                continue;
            }
            if (arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("range", arg.asElement());
                continue;
            }
            if (arg.matchesPrimitive(aH.PrimitiveType.Boolean)) {
                scriptEntry.addObject("toggle", arg.asElement());
                continue;
            }
            if (arg.matchesArgumentType(dNPC.class)) {
                ((BukkitScriptEntryData)scriptEntry.entryData).setNPC(arg.asType(dNPC.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (Utilities.getEntryNPC(scriptEntry) == null) {
            throw new InvalidArgumentsException("NPC linked was missing or invalid.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), Utilities.getEntryNPC(scriptEntry).debug() + aH.debugObj("realistic", scriptEntry.getObject("realistic")) + aH.debugObj("range", scriptEntry.getObject("range")) + aH.debugObj("toggle", scriptEntry.getObject("toggle")));
        }
        LookClose trait = (LookClose)Utilities.getEntryNPC(scriptEntry).getCitizen().getTrait(LookClose.class);
        if (scriptEntry.hasObject("toggle")) {
            trait.lookClose(scriptEntry.getElement("toggle").asBoolean());
        }
        if (scriptEntry.hasObject("realistic")) {
            trait.setRealisticLooking(true);
        } else {
            trait.setRealisticLooking(false);
        }
        if (scriptEntry.hasObject("range")) {
            trait.setRange(scriptEntry.getElement("range").asInt());
        }
    }
}

