/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.npc.traits.SittingTrait;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Sittable;

public class StandCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            arg.reportUnhandled();
        }
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("This command requires a linked NPC!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Entity entity;
        if (Utilities.getEntryNPC(scriptEntry).getEntityType() != EntityType.PLAYER && Utilities.getEntryNPC(scriptEntry).getEntityType() != EntityType.OCELOT && Utilities.getEntryNPC(scriptEntry).getEntityType() != EntityType.WOLF) {
            dB.echoError(scriptEntry.getResidingQueue(), "...only Player, ocelot, or wolf type NPCs can sit!");
            return;
        }
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugObj("npc", Utilities.getEntryNPC(scriptEntry)));
        }
        if ((entity = Utilities.getEntryNPC(scriptEntry).getEntity()) instanceof Sittable) {
            ((Sittable)entity).setSitting(false);
        } else {
            NPC npc = Utilities.getEntryNPC(scriptEntry).getCitizen();
            SittingTrait trait = (SittingTrait)npc.getTrait(SittingTrait.class);
            if (!npc.hasTrait(SittingTrait.class)) {
                npc.addTrait(SittingTrait.class);
                dB.echoDebug((Debuggable)scriptEntry, "...added sitting trait");
            }
            trait.stand();
            npc.removeTrait(SittingTrait.class);
        }
    }
}

