/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.api.npc.NPC;

public class VulnerableCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Toggle.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("action", new Element("toggle"));
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("This command requires a linked NPC!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Element action = scriptEntry.getElement("action");
        BukkitScriptEntryData entryData = (BukkitScriptEntryData)scriptEntry.entryData;
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), entryData.getNPC().debug() + action.debug());
        }
        NPC npc = entryData.getNPC().getCitizen();
        Toggle toggle = Toggle.valueOf(action.asString().toUpperCase());
        npc.setProtected(!(toggle != Toggle.TOGGLE ? action.asBoolean() : npc.isProtected()));
    }

    static enum Toggle {
        TRUE,
        FALSE,
        TOGGLE;

    }
}

