/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.interfaces.AdvancementHelper;
import net.aufdemrand.denizen.nms.util.Advancement;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AdvancementCommand
extends AbstractCommand {
    public static final Map<NamespacedKey, Advancement> customRegistered = new HashMap<NamespacedKey, Advancement>();

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("parent") && arg.matchesPrefix("parent")) {
                scriptEntry.addObject("parent", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("create") && arg.matches("create")) {
                scriptEntry.addObject("create", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("delete") && arg.matches("delete", "remove")) {
                scriptEntry.addObject("delete", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("grant") && arg.matchesPrefix("grant", "give", "g") && arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("grant", arg.asType(dList.class));
                continue;
            }
            if (!scriptEntry.hasObject("revoke") && arg.matchesPrefix("revoke", "take", "r") && arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("revoke", arg.asType(dList.class));
                continue;
            }
            if (!scriptEntry.hasObject("icon") && arg.matchesPrefix("icon", "i") && arg.matchesArgumentType(dItem.class)) {
                scriptEntry.addObject("icon", arg.asType(dItem.class));
                continue;
            }
            if (!scriptEntry.hasObject("title") && arg.matchesPrefix("title", "text", "t")) {
                scriptEntry.addObject("title", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("description") && arg.matchesPrefix("description", "desc", "d")) {
                scriptEntry.addObject("description", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("background") && arg.matchesPrefix("background", "bg")) {
                scriptEntry.addObject("background", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("frame") && arg.matchesPrefix("frame", "f") && arg.matchesEnum(Advancement.Frame.values())) {
                scriptEntry.addObject("frame", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("toast") && arg.matchesPrefix("toast", "show") && arg.matchesPrimitive(aH.PrimitiveType.Boolean)) {
                scriptEntry.addObject("toast", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("announce") && arg.matchesPrefix("announce", "chat") && arg.matchesPrimitive(aH.PrimitiveType.Boolean)) {
                scriptEntry.addObject("announce", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("hidden") && arg.matchesPrefix("hidden", "hide", "h") && arg.matchesPrimitive(aH.PrimitiveType.Boolean)) {
                scriptEntry.addObject("hidden", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("x") && arg.matchesPrefix("x") && arg.matchesPrimitive(aH.PrimitiveType.Float)) {
                scriptEntry.addObject("x", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("y") && arg.matchesPrefix("y") && arg.matchesPrimitive(aH.PrimitiveType.Float)) {
                scriptEntry.addObject("y", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify an ID!");
        }
        scriptEntry.defaultObject("icon", new dItem(Material.AIR));
        scriptEntry.defaultObject("title", new Element(""));
        scriptEntry.defaultObject("description", new Element(""));
        scriptEntry.defaultObject("background", new Element("minecraft:textures/gui/advancements/backgrounds/stone.png"));
        scriptEntry.defaultObject("frame", new Element("TASK"));
        scriptEntry.defaultObject("toast", new Element(true));
        scriptEntry.defaultObject("announce", new Element(true));
        scriptEntry.defaultObject("hidden", new Element(false));
        scriptEntry.defaultObject("x", new Element(0.0f));
        scriptEntry.defaultObject("y", new Element(0.0f));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Element id = scriptEntry.getElement("id");
        Element parent = scriptEntry.getElement("parent");
        Element delete = scriptEntry.getElement("delete");
        dList grant = (dList)scriptEntry.getdObject("grant");
        dList revoke = (dList)scriptEntry.getdObject("revoke");
        dItem icon = (dItem)scriptEntry.getdObject("icon");
        Element title = scriptEntry.getElement("title");
        Element description = scriptEntry.getElement("description");
        Element background = scriptEntry.getElement("background");
        Element frame = scriptEntry.getElement("frame");
        Element toast = scriptEntry.getElement("toast");
        Element announce = scriptEntry.getElement("announce");
        Element hidden = scriptEntry.getElement("hidden");
        Element x = scriptEntry.getElement("x");
        Element y = scriptEntry.getElement("y");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.name, id.debug() + (parent != null ? parent.debug() : "") + (delete != null ? delete.debug() : "") + (grant != null ? grant.debug() : "") + (revoke != null ? revoke.debug() : "") + icon.debug() + title.debug() + description.debug() + (background != null ? background.debug() : "") + frame.debug() + toast.debug() + announce.debug() + hidden.debug() + x.debug() + y.debug());
        }
        AdvancementHelper advancementHelper = NMSHandler.getInstance().getAdvancementHelper();
        NamespacedKey key = new NamespacedKey((Plugin)DenizenAPI.getCurrentInstance(), id.asString());
        if (delete == null && grant == null && revoke == null) {
            NamespacedKey parentKey = null;
            NamespacedKey backgroundKey = null;
            if (parent != null) {
                List<String> split = CoreUtilities.split(parent.asString(), ':', 2);
                parentKey = split.size() == 1 ? new NamespacedKey((Plugin)DenizenAPI.getCurrentInstance(), split.get(0)) : new NamespacedKey(CoreUtilities.toLowerCase(split.get(0)), CoreUtilities.toLowerCase(split.get(1)));
            } else if (background != null) {
                List<String> backgroundSplit = CoreUtilities.split(background.asString(), ':', 2);
                backgroundKey = backgroundSplit.size() == 1 ? NamespacedKey.minecraft((String)backgroundSplit.get(0)) : new NamespacedKey(CoreUtilities.toLowerCase(backgroundSplit.get(0)), CoreUtilities.toLowerCase(backgroundSplit.get(1)));
            }
            Advancement advancement = new Advancement(false, key, parentKey, icon.getItemStack(), title.asString(), description.asString(), backgroundKey, Advancement.Frame.valueOf(frame.asString().toUpperCase()), toast.asBoolean(), announce.asBoolean(), hidden.asBoolean(), x.asFloat(), y.asFloat());
            advancementHelper.register(advancement);
            customRegistered.put(key, advancement);
        } else if (delete != null) {
            advancementHelper.unregister(customRegistered.get(key));
            customRegistered.remove(key);
        } else if (grant != null) {
            Advancement advancement = customRegistered.get(key);
            for (dPlayer target : grant.filter(dPlayer.class, scriptEntry)) {
                Player player = target.getPlayerEntity();
                if (player == null) continue;
                advancementHelper.grant(advancement, player);
            }
        } else {
            Advancement advancement = customRegistered.get(key);
            for (dPlayer target : revoke.filter(dPlayer.class, scriptEntry)) {
                Player player = target.getPlayerEntity();
                if (player == null) continue;
                advancementHelper.revoke(advancement, player);
            }
        }
    }
}

