/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;

public class GroupCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (Depends.permissions == null) {
            throw new InvalidArgumentsException("Permissions not linked - is Vault improperly installed, or is there no permissions plugin?");
        }
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(dWorld.class)) {
                scriptEntry.addObject("world", arg.asType(dWorld.class));
                continue;
            }
            if (scriptEntry.hasObject("group")) continue;
            scriptEntry.addObject("group", arg.asElement());
        }
        if (!Utilities.entryHasPlayer(scriptEntry) || !Utilities.getEntryPlayer(scriptEntry).isValid()) {
            throw new InvalidArgumentsException("Must have player context!");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify valid action!");
        }
        if (!scriptEntry.hasObject("group")) {
            throw new InvalidArgumentsException("Must specify a group name!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Element action = scriptEntry.getElement("action");
        dWorld world = (dWorld)scriptEntry.getObject("world");
        Element group = scriptEntry.getElement("group");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), action.debug() + (world != null ? world.debug() : "") + group.debug());
        }
        World bukkitWorld = null;
        if (world != null) {
            bukkitWorld = world.getWorld();
        }
        OfflinePlayer player = Utilities.getEntryPlayer(scriptEntry).getOfflinePlayer();
        boolean inGroup = Depends.permissions.playerInGroup(bukkitWorld == null ? null : bukkitWorld.getName(), player, group.asString());
        switch (Action.valueOf(action.asString().toUpperCase())) {
            case ADD: {
                if (inGroup) {
                    dB.echoDebug((Debuggable)scriptEntry, "Player " + player.getName() + " is already in group " + group);
                } else {
                    Depends.permissions.playerAddGroup(bukkitWorld == null ? null : bukkitWorld.getName(), player, group.asString());
                }
                return;
            }
            case REMOVE: {
                if (!inGroup) {
                    dB.echoDebug((Debuggable)scriptEntry, "Player " + player.getName() + " is not in group " + group);
                } else {
                    Depends.permissions.playerRemoveGroup(bukkitWorld == null ? null : bukkitWorld.getName(), player, group.asString());
                }
                return;
            }
            case SET: {
                for (String grp : Depends.permissions.getPlayerGroups(bukkitWorld == null ? null : bukkitWorld.getName(), player)) {
                    Depends.permissions.playerRemoveGroup(bukkitWorld == null ? null : bukkitWorld.getName(), player, grp);
                }
                Depends.permissions.playerAddGroup(bukkitWorld == null ? null : bukkitWorld.getName(), player, group.asString());
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE,
        SET;

    }
}

