/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.milkbowl.vault.economy.Economy;

public class MoneyCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (Depends.economy == null) {
            dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
            return;
        }
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("quantity") && arg.matchesPrefix("quantity", "qty", "q") && arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                scriptEntry.addObject("quantity", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesPrefix("to", "from", "players", "player") && arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("players", arg.asType(dList.class).filter(dPlayer.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("quantity", new Element(1));
        if (!scriptEntry.hasObject("players")) {
            if (!Utilities.entryHasPlayer(scriptEntry)) {
                throw new InvalidArgumentsException("This command must have a player attached!");
            }
            scriptEntry.addObject("players", Arrays.asList(Utilities.getEntryPlayer(scriptEntry)));
        } else if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a valid action!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Element action = scriptEntry.getElement("action");
        Element quantity = scriptEntry.getElement("quantity");
        List players = (List)scriptEntry.getObject("players");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugList("Player(s)", players) + action.debug() + quantity.debug());
        }
        Economy eco = Depends.economy;
        double amt = quantity.asDouble();
        switch (Action.valueOf(action.asString().toUpperCase())) {
            case GIVE: {
                for (dPlayer player : players) {
                    eco.depositPlayer(player.getOfflinePlayer(), amt);
                }
                break;
            }
            case TAKE: {
                for (dPlayer player : players) {
                    eco.withdrawPlayer(player.getOfflinePlayer(), amt);
                }
                break;
            }
            case SET: {
                for (dPlayer player : players) {
                    double balance = eco.getBalance(player.getOfflinePlayer());
                    if (amt > balance) {
                        eco.depositPlayer(player.getOfflinePlayer(), amt - balance);
                        continue;
                    }
                    eco.withdrawPlayer(player.getOfflinePlayer(), balance - amt);
                }
                break;
            }
        }
    }

    static enum Action {
        GIVE,
        TAKE,
        SET;

    }
}

