/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.abstracts.Sidebar;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.tags.TagManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class SidebarCommand
extends AbstractCommand {
    private static final Map<UUID, Sidebar> sidebars = new HashMap<UUID, Sidebar>();

    @Override
    public void onEnable() {
        this.setParseArgs(false);
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)new SidebarEvents(), (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = Action.SET;
        for (aH.Argument arg : aH.interpret(scriptEntry.getOriginalArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                action = Action.valueOf(arg.getValue().toUpperCase());
                continue;
            }
            if (!scriptEntry.hasObject("title") && arg.matchesPrefix("title", "t", "objective", "obj", "o")) {
                scriptEntry.addObject("title", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("lines") && arg.matchesPrefix("scores", "score", "lines", "line", "l")) {
                scriptEntry.addObject("scores", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesPrefix("value", "values", "val", "v")) {
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("increment") && arg.matchesPrefix("increment", "inc", "i")) {
                scriptEntry.addObject("increment", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("start") && arg.matchesPrefix("start", "s")) {
                scriptEntry.addObject("start", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesPrefix("players", "player", "p")) {
                scriptEntry.addObject("players", arg.asElement());
                continue;
            }
            if (scriptEntry.hasObject("per_player") || !arg.matches("per_player")) continue;
            scriptEntry.addObject("per_player", new Element(true));
        }
        if (action == Action.ADD && !scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify value(s) for that action!");
        }
        if (!(action != Action.SET || scriptEntry.hasObject("value") || scriptEntry.hasObject("title") || scriptEntry.hasObject("increment") || scriptEntry.hasObject("start"))) {
            throw new InvalidArgumentsException("Must specify at least one of: value(s), title, increment, or start for that action!");
        }
        if (action == Action.SET && scriptEntry.hasObject("scores") && !scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify value(s) when setting scores!");
        }
        scriptEntry.addObject("action", new Element(action.name()));
        BukkitScriptEntryData entryData = (BukkitScriptEntryData)scriptEntry.entryData;
        scriptEntry.defaultObject("per_player", new Element(false)).defaultObject("players", new Element(entryData.hasPlayer() ? entryData.getPlayer().identify() : "li@"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        String debug;
        Element action = scriptEntry.getElement("action");
        Element elTitle = scriptEntry.getElement("title");
        Element elScores = scriptEntry.getElement("scores");
        Element elValue = scriptEntry.getElement("value");
        Element elIncrement = scriptEntry.getElement("increment");
        Element elStart = scriptEntry.getElement("start");
        Element elPlayers = scriptEntry.getElement("players");
        Element elPerPlayer = scriptEntry.getElement("per_player");
        dList players = dList.valueOf(TagManager.tag(elPlayers.asString(), new BukkitTagContext(scriptEntry, false)));
        boolean per_player = elPerPlayer.asBoolean();
        String perTitle = null;
        String perScores = null;
        String perValue = null;
        String perIncrement = null;
        String perStart = null;
        Element title = null;
        dList scores = null;
        dList value = null;
        Element increment = null;
        Element start = null;
        if (per_player) {
            if (elTitle != null) {
                perTitle = elTitle.asString();
            }
            if (elScores != null) {
                perScores = elScores.asString();
            }
            if (elValue != null) {
                perValue = elValue.asString();
            }
            if (elIncrement != null) {
                perIncrement = elIncrement.asString();
            }
            if (elStart != null) {
                perStart = elStart.asString();
            }
            debug = (elTitle != null ? elTitle.debug() : "") + (elScores != null ? elScores.debug() : "") + (elValue != null ? elValue.debug() : "") + (elIncrement != null ? elIncrement.debug() : "") + (elStart != null ? elStart.debug() : "");
        } else {
            BukkitTagContext context = (BukkitTagContext)DenizenCore.getImplementation().getTagContextFor(scriptEntry, false);
            if (elTitle != null) {
                title = new Element(TagManager.tag(elTitle.asString(), context));
            }
            if (elScores != null) {
                scores = dList.valueOf(TagManager.tag(elScores.asString(), context));
            }
            if (elValue != null) {
                value = dList.valueOf(TagManager.tag(elValue.asString(), context));
            }
            if (elIncrement != null) {
                increment = new Element(TagManager.tag(elIncrement.asString(), context));
            }
            if (elStart != null) {
                start = new Element(TagManager.tag(elStart.asString(), context));
            }
            debug = (title != null ? title.debug() : "") + (scores != null ? aH.debugObj("scores", scores) : "") + (value != null ? aH.debugObj("value", value) : "") + (increment != null ? increment.debug() : "") + (start != null ? start.debug() : "");
        }
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), action.debug() + debug + aH.debugObj("players", players.debug()));
        }
        switch (Action.valueOf(action.asString())) {
            case ADD: {
                for (dPlayer player : players.filter(dPlayer.class, scriptEntry)) {
                    if (player == null || !player.isValid()) {
                        dB.echoError("Invalid player!");
                        continue;
                    }
                    Sidebar sidebar = SidebarCommand.createSidebar(player);
                    if (sidebar == null) continue;
                    List<Sidebar.SidebarLine> current = sidebar.getLines();
                    if (per_player) {
                        BukkitTagContext context = new BukkitTagContext(player, Utilities.getEntryNPC(scriptEntry), false, scriptEntry, scriptEntry.shouldDebug(), scriptEntry.getScript());
                        value = dList.valueOf(TagManager.tag(perValue, context));
                        if (perScores != null) {
                            scores = dList.valueOf(TagManager.tag(perScores, context));
                        }
                    }
                    try {
                        int index = start != null ? start.asInt() : (current.size() > 0 ? current.get((int)(current.size() - 1)).score : value.size());
                        int incr = increment != null ? increment.asInt() : -1;
                        int i = 0;
                        while (i < value.size()) {
                            int score = scores != null && i < scores.size() ? Integer.valueOf((String)scores.get(i)) : index;
                            current.add(new Sidebar.SidebarLine((String)value.get(i), score));
                            ++i;
                            index += incr;
                        }
                    }
                    catch (Exception e) {
                        dB.echoError(e);
                        continue;
                    }
                    sidebar.setLines(current);
                    sidebar.sendUpdate();
                }
                break;
            }
            case REMOVE: {
                for (dPlayer player : players.filter(dPlayer.class, scriptEntry)) {
                    if (player == null || !player.isValid()) {
                        dB.echoError("Invalid player!");
                        continue;
                    }
                    Sidebar sidebar = SidebarCommand.createSidebar(player);
                    if (sidebar == null) continue;
                    List<Sidebar.SidebarLine> current = sidebar.getLines();
                    if (per_player) {
                        BukkitTagContext context = new BukkitTagContext(player, Utilities.getEntryNPC(scriptEntry), false, scriptEntry, scriptEntry.shouldDebug(), scriptEntry.getScript());
                        if (perValue != null) {
                            value = dList.valueOf(TagManager.tag(perValue, context));
                        }
                        if (perScores != null) {
                            scores = dList.valueOf(TagManager.tag(perScores, context));
                        }
                    }
                    if (scores != null) {
                        try {
                            for (String scoreString : scores) {
                                int score = Integer.valueOf(scoreString);
                                for (int i = 0; i < current.size(); ++i) {
                                    if (current.get((int)i).score != score) continue;
                                    current.remove(i--);
                                }
                            }
                        }
                        catch (Exception e) {
                            dB.echoError(e);
                            continue;
                        }
                        sidebar.setLines(current);
                        sidebar.sendUpdate();
                    }
                    if (value != null) {
                        for (String line : value) {
                            for (int i = 0; i < current.size(); ++i) {
                                if (!current.get((int)i).text.equalsIgnoreCase(line)) continue;
                                current.remove(i--);
                            }
                        }
                        sidebar.setLines(current);
                        sidebar.sendUpdate();
                        continue;
                    }
                    sidebar.remove();
                    sidebars.remove(player.getPlayerEntity().getUniqueId());
                }
                break;
            }
            case SET: {
                for (dPlayer player : players.filter(dPlayer.class, scriptEntry)) {
                    if (player == null || !player.isValid()) {
                        dB.echoError("Invalid player!");
                        continue;
                    }
                    Sidebar sidebar = SidebarCommand.createSidebar(player);
                    if (sidebar == null) continue;
                    ArrayList<Sidebar.SidebarLine> current = new ArrayList<Sidebar.SidebarLine>();
                    boolean currEdited = false;
                    if (per_player) {
                        BukkitTagContext context = new BukkitTagContext(player, Utilities.getEntryNPC(scriptEntry), false, scriptEntry, scriptEntry.shouldDebug(), scriptEntry.getScript());
                        if (perValue != null) {
                            value = dList.valueOf(TagManager.tag(perValue, context));
                        }
                        if (perScores != null) {
                            scores = dList.valueOf(TagManager.tag(perScores, context));
                        }
                        if (perStart != null) {
                            start = new Element(TagManager.tag(perStart, context));
                        }
                        if (perIncrement != null) {
                            increment = new Element(TagManager.tag(perIncrement, context));
                        }
                        if (perTitle != null) {
                            title = new Element(TagManager.tag(perTitle, context));
                        }
                    }
                    if (value != null) {
                        try {
                            int index = start != null ? start.asInt() : value.size();
                            int incr = increment != null ? increment.asInt() : -1;
                            int i = 0;
                            while (i < value.size()) {
                                int score = scores != null && i < scores.size() ? Integer.valueOf((String)scores.get(i)) : index;
                                current.add(new Sidebar.SidebarLine((String)value.get(i), score));
                                ++i;
                                index += incr;
                            }
                        }
                        catch (Exception e) {
                            dB.echoError(e);
                            continue;
                        }
                        currEdited = true;
                    }
                    if (title != null) {
                        sidebar.setTitle(title.asString());
                    }
                    if (currEdited) {
                        sidebar.setLines(current);
                    }
                    sidebar.sendUpdate();
                }
                break;
            }
        }
    }

    private static Sidebar createSidebar(dPlayer denizenPlayer) {
        if (!denizenPlayer.isOnline()) {
            return null;
        }
        Player player = denizenPlayer.getPlayerEntity();
        UUID uuid = player.getUniqueId();
        if (!sidebars.containsKey(uuid)) {
            sidebars.put(uuid, NMSHandler.getInstance().createSidebar(player));
        }
        return sidebars.get(player.getUniqueId());
    }

    public static Sidebar getSidebar(dPlayer denizenPlayer) {
        if (!denizenPlayer.isOnline()) {
            return null;
        }
        return sidebars.get(denizenPlayer.getPlayerEntity().getUniqueId());
    }

    public static class SidebarEvents
    implements Listener {
        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            UUID uuid = event.getPlayer().getUniqueId();
            if (sidebars.containsKey(uuid)) {
                sidebars.remove(uuid);
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE,
        SET;

    }
}

