/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.server;

import java.util.Date;
import java.util.List;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.BanList;
import org.bukkit.Bukkit;

public class BanCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("action") && (arg.matchesPrefix("action") || arg.matchesEnum(Actions.values()))) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("addresses") && arg.matchesPrefix("addresses", "address")) {
                scriptEntry.addObject("addresses", arg.asType(dList.class));
                continue;
            }
            if (!scriptEntry.hasObject("targets") && (arg.matchesPrefix("targets", "target") || arg.matchesArgumentList(dPlayer.class))) {
                scriptEntry.addObject("targets", arg.asType(dList.class).filter(dPlayer.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("reason") && arg.matchesPrefix("reason")) {
                scriptEntry.addObject("reason", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("duration") && (arg.matchesPrefix("duration", "time", "d", "expiration") || arg.matchesArgumentType(Duration.class))) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("source") && arg.matchesPrefix("source")) {
                scriptEntry.addObject("source", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("action", new Element("add")).defaultObject("reason", new Element("Banned.")).defaultObject("source", new Element("(Unknown)"));
        if (Actions.valueOf(scriptEntry.getObject("action").toString().toUpperCase()) == null) {
            throw new IllegalArgumentException("Invalid action specified.");
        }
        if (!(scriptEntry.hasObject("targets") && !((List)scriptEntry.getObject("targets")).isEmpty() || scriptEntry.hasObject("addresses") && !((List)scriptEntry.getObject("addresses")).isEmpty())) {
            throw new IllegalArgumentException("Must specify a valid target or address!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Element action = scriptEntry.getElement("action");
        List targets = (List)scriptEntry.getObject("targets");
        dList addresses = (dList)scriptEntry.getObject("addresses");
        Element reason = scriptEntry.getElement("reason");
        Duration duration = (Duration)scriptEntry.getdObject("duration");
        Element source = scriptEntry.getElement("source");
        Date expiration = null;
        if (duration != null && duration.getTicks() != 0L) {
            expiration = new Date(new Duration(System.currentTimeMillis() / 50L + duration.getTicks()).getTicks() * 50L);
        }
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), action.debug() + (targets != null ? aH.debugObj("targets", targets) : "") + (addresses != null ? addresses.debug() : "") + reason.debug() + (duration != null ? duration.debug() : "") + source.debug());
        }
        Actions banAction = Actions.valueOf(action.toString().toUpperCase());
        switch (banAction) {
            case ADD: {
                if (targets != null) {
                    for (dPlayer player : targets) {
                        if (!player.isValid()) continue;
                        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), reason.toString(), expiration, source.toString());
                        if (!player.isOnline()) continue;
                        player.getPlayerEntity().kickPlayer(reason.toString());
                    }
                }
                if (addresses == null) break;
                for (String address : addresses) {
                    Bukkit.getBanList((BanList.Type)BanList.Type.IP).addBan(address, reason.toString(), expiration, source.toString());
                }
                break;
            }
            case REMOVE: {
                if (targets != null) {
                    for (dPlayer player : targets) {
                        if (!player.isValid() || !player.getOfflinePlayer().isBanned()) continue;
                        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).pardon(player.getName());
                    }
                }
                if (addresses == null) break;
                for (String address : addresses) {
                    Bukkit.getBanList((BanList.Type)BanList.Type.IP).pardon(address);
                }
                break;
            }
        }
    }

    public static enum Actions {
        ADD,
        REMOVE;

    }
}

