/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.server;

import java.util.List;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.FakeOfflinePlayer;
import net.aufdemrand.denizen.utilities.ScoreboardHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class ScoreboardCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("lines") && arg.matchesPrefix("lines", "l")) {
                scriptEntry.addObject("lines", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("objective") && arg.matchesPrefix("objective", "obj", "o")) {
                scriptEntry.addObject("objective", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("criteria") && arg.matchesPrefix("criteria", "c")) {
                scriptEntry.addObject("criteria", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("score") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("score", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("displayslot") && (arg.matchesEnum((Enum<?>[])DisplaySlot.values()) || arg.matches("none"))) {
                scriptEntry.addObject("displayslot", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("viewers") && arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("viewers", arg.asType(dList.class).filter(dPlayer.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("action", new Element("add"));
        scriptEntry.defaultObject("id", new Element("main"));
        scriptEntry.defaultObject("criteria", new Element("dummy"));
        scriptEntry.defaultObject("displayslot", new Element("sidebar"));
    }

    public static OfflinePlayer getOfflinePlayer(String name) {
        if (dPlayer.playerNameIsValid(name)) {
            return Bukkit.getOfflinePlayer((String)name);
        }
        return new FakeOfflinePlayer(name);
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List viewers = (List)scriptEntry.getObject("viewers");
        dList lines = scriptEntry.hasObject("lines") ? dList.valueOf(scriptEntry.getElement("lines").asString()) : new dList();
        Element action = scriptEntry.getElement("action");
        Element id = scriptEntry.getElement("id");
        Element objective = scriptEntry.getElement("objective");
        Element criteria = scriptEntry.getElement("criteria");
        Element score = scriptEntry.getElement("score");
        Element displaySlot = scriptEntry.getElement("displayslot");
        Action act = Action.valueOf(action.asString().toUpperCase());
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), action.debug() + id.debug() + (viewers != null ? aH.debugObj("viewers", viewers.toString()) : "") + (objective != null ? objective.debug() : "") + (act.equals((Object)Action.ADD) && objective != null ? criteria.debug() : "") + (!lines.isEmpty() ? lines.debug() : "") + (act.equals((Object)Action.ADD) && score != null ? score.debug() : "") + (act.equals((Object)Action.ADD) && objective != null ? displaySlot.debug() : ""));
        }
        Scoreboard board = null;
        if (id.asString().equalsIgnoreCase("main")) {
            board = ScoreboardHelper.getMain();
        } else if (ScoreboardHelper.hasScoreboard(id.asString())) {
            board = ScoreboardHelper.getScoreboard(id.asString());
        } else if (act.equals((Object)Action.ADD)) {
            board = ScoreboardHelper.createScoreboard(id.asString());
        }
        if (board == null) {
            dB.echoError(scriptEntry.getResidingQueue(), "Scoreboard " + id.asString() + " does not exist!");
            return;
        }
        Objective obj = null;
        if (act.equals((Object)Action.ADD)) {
            if (objective != null) {
                obj = board.getObjective(objective.asString());
                if (obj == null) {
                    obj = board.registerNewObjective(objective.asString(), criteria.asString());
                } else if (criteria != null && !obj.getCriteria().equals(criteria.asString())) {
                    obj.unregister();
                    obj = board.registerNewObjective(objective.asString(), criteria.asString());
                }
                if (!displaySlot.asString().equalsIgnoreCase("none")) {
                    obj.setDisplaySlot(DisplaySlot.valueOf((String)displaySlot.asString().toUpperCase()));
                }
                obj.setDisplayName(objective.asString());
                if (!lines.isEmpty()) {
                    if (score == null) {
                        score = new Element(0);
                    }
                    for (String line : lines) {
                        if ((line = line.replaceAll("[pP]@", "")).length() > 48) {
                            line = line.substring(0, 48);
                        }
                        ScoreboardHelper.addScore(obj, ScoreboardCommand.getOfflinePlayer(line), score.asInt());
                    }
                }
            } else if (viewers == null && !lines.isEmpty()) {
                dB.echoDebug((Debuggable)scriptEntry, "Cannot add lines without specifying an objective!");
            }
        } else if (act.equals((Object)Action.REMOVE)) {
            if (objective != null) {
                obj = board.getObjective(objective.asString());
                if (obj != null) {
                    if (lines.isEmpty()) {
                        dB.echoDebug((Debuggable)scriptEntry, "Removing objective " + obj.getName() + " from scoreboard " + id.asString());
                        obj.unregister();
                    } else {
                        for (String line : lines) {
                            line = line.replaceAll("[pP]@", "");
                            ScoreboardHelper.removeScore(obj, ScoreboardCommand.getOfflinePlayer(line));
                        }
                    }
                } else {
                    dB.echoError(scriptEntry.getResidingQueue(), "Objective " + objective.asString() + " does not exist in scoreboard " + id.asString());
                }
            } else if (!lines.isEmpty()) {
                dB.echoDebug((Debuggable)scriptEntry, "Removing lines " + lines.identify() + " from all objectives in scoreboard " + id.asString());
                for (String line : lines) {
                    line = line.replaceAll("[pP]@", "");
                    ScoreboardHelper.removePlayer(id.asString(), ScoreboardCommand.getOfflinePlayer(line));
                }
            } else if (viewers == null) {
                dB.echoDebug((Debuggable)scriptEntry, "Removing scoreboard " + id.asString());
                ScoreboardHelper.deleteScoreboard(id.asString());
            }
        }
        if (viewers != null) {
            for (dPlayer viewer : viewers) {
                if (act.equals((Object)Action.ADD)) {
                    if (!id.asString().equalsIgnoreCase("main")) {
                        ScoreboardHelper.viewerMap.put(viewer.getName(), id.asString());
                    }
                    if (!viewer.isOnline()) continue;
                    viewer.getPlayerEntity().setScoreboard(board);
                    continue;
                }
                if (!act.equals((Object)Action.REMOVE)) continue;
                ScoreboardHelper.viewerMap.remove(viewer.getName());
                if (!viewer.isOnline()) continue;
                viewer.getPlayerEntity().setScoreboard(ScoreboardHelper.createScoreboard());
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE;

    }
}

