/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.io.File;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;

public class CreateWorldCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("generator") && arg.matchesPrefix("generator", "g")) {
                scriptEntry.addObject("generator", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("worldtype") && arg.matchesPrefix("worldtype") && arg.matchesEnum((Enum<?>[])WorldType.values())) {
                scriptEntry.addObject("worldtype", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("environment") && arg.matchesPrefix("environment") && arg.matchesEnum((Enum<?>[])World.Environment.values())) {
                scriptEntry.addObject("environment", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("copy_from") && arg.matchesPrefix("copy_from")) {
                scriptEntry.addObject("copy_from", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("seed") && arg.matchesPrefix("seed", "s") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("seed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("world_name")) {
                scriptEntry.addObject("world_name", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("world_name")) {
            throw new InvalidArgumentsException("Must specify a world name.");
        }
        if (!scriptEntry.hasObject("worldtype")) {
            scriptEntry.addObject("worldtype", new Element("NORMAL"));
        }
        scriptEntry.defaultObject("environment", new Element("NORMAL"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        World world;
        Element worldName = scriptEntry.getElement("world_name");
        Element generator = scriptEntry.getElement("generator");
        Element worldType = scriptEntry.getElement("worldtype");
        Element environment = scriptEntry.getElement("environment");
        Element copy_from = scriptEntry.getElement("copy_from");
        Element seed = scriptEntry.getElement("seed");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), worldName.debug() + (generator != null ? generator.debug() : "") + environment.debug() + (copy_from != null ? copy_from.debug() : "") + worldType.debug() + (seed != null ? seed.debug() : ""));
        }
        if (copy_from != null) {
            try {
                File file2;
                if (copy_from.asString().contains("..")) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Invalid copy from world name!");
                    return;
                }
                File newFolder = new File(worldName.asString());
                File folder = new File(copy_from.asString().replace("w@", ""));
                if (!folder.exists() || !folder.isDirectory()) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Invalid copy from world folder - does not exist!");
                    return;
                }
                CoreUtilities.copyDirectory(folder, newFolder);
                File file = new File(worldName.asString() + "/uid.dat");
                if (file.exists()) {
                    file.delete();
                }
                if ((file2 = new File(worldName.asString() + "/session.lock")).exists()) {
                    file2.delete();
                }
            }
            catch (Exception ex) {
                dB.echoError(ex);
                return;
            }
        }
        WorldCreator worldCreator = WorldCreator.name((String)worldName.asString()).environment(World.Environment.valueOf((String)environment.asString().toUpperCase())).type(WorldType.valueOf((String)worldType.asString().toUpperCase()));
        if (generator != null) {
            worldCreator.generator(generator.asString());
        }
        if (seed != null) {
            worldCreator.seed(seed.asLong());
        }
        if ((world = Bukkit.getServer().createWorld(worldCreator)) == null) {
            dB.echoDebug((Debuggable)scriptEntry, "World is null, something went wrong in creation!");
        }
    }
}

