/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.abstracts.ParticleHelper;
import net.aufdemrand.denizen.nms.interfaces.Particle;
import net.aufdemrand.denizen.objects.dColor;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class PlayEffectCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ParticleHelper particleHelper = NMSHandler.getInstance().getParticleHelper();
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentList(dLocation.class)) {
                if (arg.matchesOnePrefix("at")) {
                    scriptEntry.addObject("no_offset", new Element(true));
                }
                scriptEntry.addObject("location", arg.asType(dList.class).filter(dLocation.class, scriptEntry));
                continue;
            }
            if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack") || scriptEntry.hasObject("blockcrack") || scriptEntry.hasObject("blockdust"))) {
                dMaterial material;
                if (particleHelper.hasParticle(arg.getValue())) {
                    scriptEntry.addObject("particleeffect", particleHelper.getParticle(arg.getValue()));
                    continue;
                }
                if (arg.matches("random")) {
                    List<Particle> visible = particleHelper.getVisibleParticles();
                    scriptEntry.addObject("particleeffect", visible.get(CoreUtilities.getRandom().nextInt(visible.size())));
                    continue;
                }
                if (arg.startsWith("iconcrack_")) {
                    String shrunk = arg.getValue().substring("iconcrack_".length());
                    dItem item = dItem.valueOf(shrunk, scriptEntry.entryData.getTagContext());
                    if (item != null) {
                        scriptEntry.addObject("iconcrack", item);
                        continue;
                    }
                    dB.echoError("Invalid iconcrack_[item]. Must be a valid dItem!");
                    continue;
                }
                if (arg.startsWith("blockcrack_")) {
                    String shrunk = arg.getValue().substring("blockcrack_".length());
                    material = dMaterial.valueOf(shrunk);
                    if (material != null) {
                        scriptEntry.addObject("blockcrack", material);
                        continue;
                    }
                    dB.echoError("Invalid blockcrack_[item]. Must be a valid dMaterial!");
                    continue;
                }
                if (arg.startsWith("blockdust_")) {
                    String shrunk = arg.getValue().substring("blockdust_".length());
                    material = dMaterial.valueOf(shrunk);
                    if (material != null) {
                        scriptEntry.addObject("blockdust", material);
                        continue;
                    }
                    dB.echoError("Invalid blockdust_[item]. Must be a valid dMaterial!");
                    continue;
                }
                if (arg.matchesEnum((Enum<?>[])Effect.values())) {
                    scriptEntry.addObject("effect", Effect.valueOf((String)arg.getValue().toUpperCase()));
                    continue;
                }
                if (NMSHandler.getInstance().getParticleHelper().effectRemap.containsKey(arg.getValue().toUpperCase())) {
                    scriptEntry.addObject("effect", NMSHandler.getInstance().getParticleHelper().effectRemap.get(arg.getValue().toUpperCase()));
                }
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("visibility", "v", "radius", "r")) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("data") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("data", "d")) {
                scriptEntry.addObject("data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("special_data") && arg.matchesOnePrefix("special_data")) {
                scriptEntry.addObject("special_data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesPrimitive(aH.PrimitiveType.Integer) && arg.matchesPrefix("qty", "q", "quantity")) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("offset", "o")) {
                double offset = arg.asElement().asDouble();
                scriptEntry.addObject("offset", new dLocation(null, offset, offset, offset));
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesArgumentType(dLocation.class) && arg.matchesPrefix("offset", "o")) {
                scriptEntry.addObject("offset", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("targets") && arg.matchesArgumentList(dPlayer.class) && arg.matchesPrefix("targets", "target", "t")) {
                scriptEntry.addObject("targets", arg.asType(dList.class).filter(dPlayer.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("location", Utilities.entryHasNPC(scriptEntry) && Utilities.getEntryNPC(scriptEntry).isSpawned() ? Arrays.asList(Utilities.getEntryNPC(scriptEntry).getLocation()) : null, Utilities.entryHasPlayer(scriptEntry) && Utilities.getEntryPlayer(scriptEntry).isOnline() ? Arrays.asList(Utilities.getEntryPlayer(scriptEntry).getLocation()) : null);
        scriptEntry.defaultObject("data", new Element(0));
        scriptEntry.defaultObject("radius", new Element(15));
        scriptEntry.defaultObject("qty", new Element(1));
        scriptEntry.defaultObject("offset", new dLocation(null, 0.5, 0.5, 0.5));
        if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack") || scriptEntry.hasObject("blockcrack") || scriptEntry.hasObject("blockdust"))) {
            throw new InvalidArgumentsException("Missing effect argument!");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List locations = (List)scriptEntry.getObject("location");
        List targets = (List)scriptEntry.getObject("targets");
        Effect effect = (Effect)scriptEntry.getObject("effect");
        Particle particleEffect = (Particle)scriptEntry.getObject("particleeffect");
        dItem iconcrack = (dItem)scriptEntry.getdObject("iconcrack");
        dMaterial blockcrack = (dMaterial)scriptEntry.getdObject("blockcrack");
        dMaterial blockdust = (dMaterial)scriptEntry.getdObject("blockdust");
        Element radius = scriptEntry.getElement("radius");
        Element data = scriptEntry.getElement("data");
        Element qty = scriptEntry.getElement("qty");
        Element no_offset = scriptEntry.getElement("no_offset");
        boolean should_offset = no_offset == null || !no_offset.asBoolean();
        dLocation offset = (dLocation)scriptEntry.getdObject("offset");
        Element special_data = scriptEntry.getElement("special_data");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), (effect != null ? aH.debugObj("effect", effect.name()) : (particleEffect != null ? aH.debugObj("special effect", particleEffect.getName()) : (iconcrack != null ? iconcrack.debug() : (blockcrack != null ? blockcrack.debug() : blockdust.debug())))) + aH.debugObj("locations", locations.toString()) + (targets != null ? aH.debugObj("targets", targets.toString()) : "") + radius.debug() + data.debug() + qty.debug() + offset.debug() + (special_data != null ? special_data.debug() : "") + (should_offset ? aH.debugObj("note", "Location will be offset 1 block-height upward (see documentation)") : ""));
        }
        for (dLocation location : locations) {
            if (should_offset) {
                location = new dLocation(location.clone().add(0.0, 1.0, 0.0));
            }
            if (effect != null) {
                for (int n = 0; n < qty.asInt(); ++n) {
                    if (targets != null) {
                        for (dPlayer player : targets) {
                            if (!player.isValid() || !player.isOnline()) continue;
                            player.getPlayerEntity().playEffect((Location)location, effect, data.asInt());
                        }
                        continue;
                    }
                    location.getWorld().playEffect((Location)location, effect, data.asInt(), radius.asInt());
                }
                continue;
            }
            if (particleEffect != null) {
                float osX = (float)offset.getX();
                float osY = (float)offset.getY();
                float osZ = (float)offset.getZ();
                ArrayList<Player> players = new ArrayList<Player>();
                if (targets == null) {
                    float rad = radius.asFloat();
                    for (Player player : location.getWorld().getPlayers()) {
                        if (!(player.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                        players.add(player);
                    }
                } else {
                    for (dPlayer dPlayer2 : targets) {
                        if (!dPlayer2.isValid() || !dPlayer2.isOnline()) continue;
                        players.add(dPlayer2.getPlayerEntity());
                    }
                }
                for (Player player : players) {
                    Class clazz = particleEffect.neededData();
                    if (clazz == null) {
                        particleEffect.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat());
                        continue;
                    }
                    Particle.DustOptions dataObject = null;
                    if (special_data == null) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Missing required special data for particle: " + particleEffect.getName());
                    } else if (clazz == Particle.DustOptions.class) {
                        dList dataList = dList.valueOf(special_data.asString());
                        if (dataList.size() != 2) {
                            dB.echoError(scriptEntry.getResidingQueue(), "DustOptions special_data must have 2 list entries for particle: " + particleEffect.getName());
                        } else {
                            float size = aH.getFloatFrom((String)dataList.get(0));
                            dColor color = dColor.valueOf((String)dataList.get(1));
                            dataObject = new Particle.DustOptions(color.getColor(), size);
                        }
                    } else {
                        dB.echoError(scriptEntry.getResidingQueue(), "Unknown particle data type: " + clazz.getCanonicalName() + " for particle: " + particleEffect.getName());
                    }
                    particleEffect.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat(), dataObject);
                }
                continue;
            }
            ArrayList<Player> players = new ArrayList<Player>();
            if (targets == null) {
                float rad = radius.asFloat();
                for (Player player : location.getWorld().getPlayers()) {
                    if (!(player.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                    players.add(player);
                }
            } else {
                for (dPlayer player : targets) {
                    if (!player.isValid() || !player.isOnline()) continue;
                    players.add(player.getPlayerEntity());
                }
            }
            if (iconcrack != null) {
                ItemStack itemStack = iconcrack.getItemStack();
                Particle particle = NMSHandler.getInstance().getParticleHelper().getParticle("ITEM_CRACK");
                for (Player player : players) {
                    particle.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat(), itemStack);
                }
                continue;
            }
            if (blockcrack != null) {
                MaterialData materialData = blockcrack.getMaterialData();
                Particle particle = NMSHandler.getInstance().getParticleHelper().getParticle("BLOCK_CRACK");
                for (Player player : players) {
                    particle.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat(), materialData);
                }
                continue;
            }
            MaterialData materialData = blockdust.getMaterialData();
            Particle particle = NMSHandler.getInstance().getParticleHelper().getParticle("BLOCK_DUST");
            for (Player player : players) {
                particle.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat(), materialData);
            }
        }
    }
}

