/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class TimeCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("value", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(dWorld.class)) {
                scriptEntry.addObject("world", arg.asType(dWorld.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify a value!");
        }
        if (!scriptEntry.hasObject("world")) {
            scriptEntry.addObject("world", Utilities.entryHasNPC(scriptEntry) ? new dWorld(Utilities.getEntryNPC(scriptEntry).getWorld()) : (Utilities.entryHasPlayer(scriptEntry) ? new dWorld(Utilities.getEntryPlayer(scriptEntry).getWorld()) : null));
        }
        scriptEntry.defaultObject("type", new Element("GLOBAL"));
        if (!scriptEntry.hasObject("world")) {
            throw new InvalidArgumentsException("Must specify a valid world!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Duration value = (Duration)scriptEntry.getObject("value");
        dWorld world = (dWorld)scriptEntry.getObject("world");
        Element type_element = scriptEntry.getElement("type");
        Type type = Type.valueOf(type_element.asString().toUpperCase());
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), type_element.debug() + value.debug() + world.debug());
        }
        if (type.equals((Object)Type.GLOBAL)) {
            world.getWorld().setTime(value.getTicks());
        } else if (!Utilities.entryHasPlayer(scriptEntry)) {
            dB.echoError("Must have a valid player link!");
        } else {
            Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setPlayerTime(value.getTicks(), true);
        }
    }

    private static enum Type {
        GLOBAL,
        PLAYER;

    }
}

