/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Bukkit;
import org.bukkit.WeatherType;

public class WeatherCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", (Object)Type.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(dWorld.class)) {
                scriptEntry.addObject("world", arg.asType(dWorld.class));
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesEnum(Value.values())) {
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify a value!");
        }
        scriptEntry.defaultObject("world", Utilities.entryHasNPC(scriptEntry) ? new dWorld(Utilities.getEntryNPC(scriptEntry).getWorld()) : null, Utilities.entryHasPlayer(scriptEntry) ? new dWorld(Utilities.getEntryPlayer(scriptEntry).getWorld()) : null, Bukkit.getWorlds().get(0));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Type type;
        Value value = Value.valueOf(((Element)scriptEntry.getObject("value")).asString().toUpperCase());
        dWorld world = (dWorld)scriptEntry.getObject("world");
        Type type2 = type = scriptEntry.hasObject("type") ? (Type)((Object)scriptEntry.getObject("type")) : Type.GLOBAL;
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugObj("type", type.name()) + (type.name().equalsIgnoreCase("player") ? aH.debugObj("player", Utilities.getEntryPlayer(scriptEntry)) : "") + (type.name().equalsIgnoreCase("global") ? aH.debugObj("world", world) : "") + aH.debugObj("value", (Object)value));
        }
        switch (value) {
            case SUNNY: {
                if (type.equals((Object)Type.GLOBAL)) {
                    world.getWorld().setStorm(false);
                    world.getWorld().setThundering(false);
                    break;
                }
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setPlayerWeather(WeatherType.CLEAR);
                break;
            }
            case STORM: {
                if (type.equals((Object)Type.GLOBAL)) {
                    world.getWorld().setStorm(true);
                    break;
                }
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setPlayerWeather(WeatherType.DOWNFALL);
                break;
            }
            case THUNDER: {
                if (type.equals((Object)Type.GLOBAL)) {
                    world.getWorld().setThundering(true);
                    break;
                }
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setPlayerWeather(WeatherType.DOWNFALL);
            }
        }
    }

    private static enum Value {
        SUNNY,
        STORM,
        THUNDER;

    }

    private static enum Type {
        GLOBAL,
        PLAYER;

    }
}

