/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.SlowWarning;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class PlayerTags
implements Listener {
    public static Map<UUID, List<String>> playerChatHistory = new ConcurrentHashMap<UUID, List<String>>(8, 0.9f, 2);
    public SlowWarning playerShorthand = new SlowWarning("Short-named tags are hard to read. Please use 'player' instead of 'pl' as a root tag.");

    public PlayerTags() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                PlayerTags.this.playerTags(event);
            }
        }, "player", "pl");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void addMessage(final AsyncPlayerChatEvent event) {
        final int maxSize = Settings.chatHistoryMaxMessages();
        if (maxSize > 0) {
            Bukkit.getScheduler().runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                @Override
                public void run() {
                    List<String> history = playerChatHistory.get(event.getPlayer().getUniqueId());
                    if (history == null) {
                        history = new ArrayList<String>();
                    }
                    if (history.size() > maxSize) {
                        history.remove(maxSize - 1);
                    }
                    history.add(0, event.getMessage());
                    playerChatHistory.put(event.getPlayer().getUniqueId(), history);
                }
            }, 1L);
        }
    }

    public void playerTags(ReplaceableTagEvent event) {
        if (!event.matches("player", "pl") || event.replaced()) {
            return;
        }
        if (event.matches("pl")) {
            this.playerShorthand.warn(event.getScriptEntry());
        }
        Attribute attribute = event.getAttributes();
        dPlayer p = ((BukkitTagContext)event.getContext()).player;
        if (attribute.hasContext(1)) {
            p = dPlayer.valueOf(attribute.getContext(1), attribute.context);
        }
        if (p == null || !p.isValid()) {
            if (!event.hasAlternative()) {
                dB.echoError("Invalid or missing player for tag <" + event.raw_tag + ">!");
            }
            return;
        }
        event.setReplacedObject(CoreUtilities.autoAttrib(p, attribute.fulfill(1)));
    }
}

