/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class DataPersistenceHelper {
    public static final DenizenObjectType PERSISTER_TYPE = new DenizenObjectType();

    public static void setDenizenKey(Entity entity, String keyName, dObject keyValue) {
        entity.getPersistentDataContainer().set(new NamespacedKey((Plugin)DenizenAPI.getCurrentInstance(), keyName), (PersistentDataType)PERSISTER_TYPE, (Object)keyValue);
    }

    public static boolean hasDenizenKey(Entity entity, String keyName) {
        return entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)DenizenAPI.getCurrentInstance(), keyName), (PersistentDataType)PERSISTER_TYPE);
    }

    public static dObject getDenizenKey(Entity entity, String keyName) {
        try {
            return (dObject)entity.getPersistentDataContainer().get(new NamespacedKey((Plugin)DenizenAPI.getCurrentInstance(), keyName), (PersistentDataType)PERSISTER_TYPE);
        }
        catch (NullPointerException ex) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            dB.echoError("Failed to read dObject from entity key '" + keyName + "' for entity " + entity.getUniqueId() + "...");
            dB.echoError(ex);
            return null;
        }
    }

    public static class DenizenObjectType
    implements PersistentDataType<String, dObject> {
        public Class<String> getPrimitiveType() {
            return String.class;
        }

        public Class<dObject> getComplexType() {
            return dObject.class;
        }

        public String toPrimitive(dObject complex, PersistentDataAdapterContext context) {
            return complex.toString();
        }

        public dObject fromPrimitive(String primitive, PersistentDataAdapterContext context) {
            return ObjectFetcher.pickObjectFor(primitive);
        }
    }
}

